/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.telemetry;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.microprofile.telemetry.HelidonTelemetryContainerFilter;
import io.helidon.microprofile.telemetry.spi.HelidonTelemetryClientFilterHelper;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

@Provider
class HelidonTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final System.Logger LOGGER = System.getLogger(HelidonTelemetryContainerFilter.class.getName());
    private static final String HTTP_URL = "http.url";
    private static final String SPAN_SCOPE = Scope.class.getName();
    private static final String SPAN = Span.class.getName();
    private static final Set<Response.Status.Family> ERROR_STATUS_FAMILIES = Set.of(Response.Status.Family.CLIENT_ERROR, Response.Status.Family.SERVER_ERROR);
    private static final String HELPER_START_SPAN_PROPERTY = HelidonTelemetryClientFilterHelper.class.getName() + ".startSpan";
    private final Tracer helidonTracer;
    private final List<HelidonTelemetryClientFilterHelper> helpers;

    @Inject
    HelidonTelemetryClientFilter(Tracer helidonTracer, Instance<HelidonTelemetryClientFilterHelper> helpersInstance) {
        this.helidonTracer = helidonTracer;
        this.helpers = helpersInstance.stream().toList();
    }

    public void filter(ClientRequestContext clientRequestContext) {
        boolean startSpan = this.helpers.stream().allMatch(h -> h.shouldStartSpan(clientRequestContext));
        clientRequestContext.setProperty(HELPER_START_SPAN_PROPERTY, (Object)startSpan);
        if (!startSpan) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Client filter helper(s) voted to not start a span for " + String.valueOf(clientRequestContext.getUri()));
            }
            return;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Starting Span in a Client Request");
        }
        Span helidonSpan = ((Span.Builder)this.helidonTracer.spanBuilder("HTTP " + clientRequestContext.getMethod()).kind(Span.Kind.CLIENT).tag("http.method", clientRequestContext.getMethod()).tag("http.scheme", clientRequestContext.getUri().getScheme()).tag(HTTP_URL, clientRequestContext.getUri().toString()).tag(SemanticAttributes.NET_PEER_NAME.getKey(), clientRequestContext.getUri().getHost()).tag(SemanticAttributes.NET_PEER_PORT.getKey(), (Number)clientRequestContext.getUri().getPort()).update(builder -> Span.current().map(Span::context).ifPresent(arg_0 -> ((Span.Builder)builder).parent(arg_0)))).start();
        Baggage.fromContext((Context)Context.current()).forEach((key, baggageEntry) -> helidonSpan.baggage().set(key, baggageEntry.getValue(), baggageEntry.getMetadata().getValue()));
        Scope helidonScope = helidonSpan.activate();
        clientRequestContext.setProperty(SPAN_SCOPE, (Object)helidonScope);
        clientRequestContext.setProperty(SPAN, (Object)helidonSpan);
        this.helidonTracer.inject(helidonSpan.context(), HeaderProvider.empty(), (HeaderConsumer)new RequestContextHeaderInjector((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) {
        Span span;
        Boolean startSpanObj = (Boolean)clientRequestContext.getProperty(HELPER_START_SPAN_PROPERTY);
        if (startSpanObj != null && !startSpanObj.booleanValue()) {
            return;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Closing Span in a Client Response");
        }
        if ((span = (Span)clientRequestContext.getProperty(SPAN)) == null) {
            return;
        }
        Scope scope = (Scope)clientRequestContext.getProperty(SPAN_SCOPE);
        scope.close();
        span.tag("http.status_code", (Number)clientResponseContext.getStatus());
        if (ERROR_STATUS_FAMILIES.contains(clientResponseContext.getStatusInfo().getFamily())) {
            span.status(Span.Status.ERROR);
        }
        span.end();
        clientRequestContext.removeProperty(SPAN);
        clientRequestContext.removeProperty(SPAN_SCOPE);
    }

    private static List<HelidonTelemetryClientFilterHelper> helpers() {
        return HelidonServiceLoader.create(ServiceLoader.load(HelidonTelemetryClientFilterHelper.class)).asList();
    }

    private static class RequestContextHeaderInjector
    implements HeaderConsumer {
        private final MultivaluedMap<String, Object> requestHeaders;

        private RequestContextHeaderInjector(MultivaluedMap<String, Object> headers) {
            this.requestHeaders = headers;
        }

        public void setIfAbsent(String key, String ... values) {
            this.requestHeaders.computeIfAbsent((Object)key, k -> List.of(values));
        }

        public void set(String key, String ... values) {
            this.requestHeaders.put((Object)key, List.of(values));
        }

        public Iterable<String> keys() {
            return this.requestHeaders.keySet();
        }

        public Optional<String> get(String key) {
            return Optional.ofNullable((String)this.requestHeaders.getFirst((Object)key));
        }

        public Iterable<String> getAll(String key) {
            return ((List)this.requestHeaders.get((Object)key)).stream().map(o -> (String)o).toList();
        }

        public boolean contains(String key) {
            return this.requestHeaders.containsKey((Object)key);
        }
    }
}

