/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.telemetry;

import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.microprofile.telemetry.RequestContextHeaderProvider;
import io.helidon.microprofile.telemetry.spi.HelidonTelemetryContainerFilterHelper;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.Resource;

@Provider
class HelidonTelemetryContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final System.Logger LOGGER = System.getLogger(HelidonTelemetryContainerFilter.class.getName());
    private static final String SPAN = Span.class.getName();
    private static final String SPAN_SCOPE = Scope.class.getName();
    private static final String HTTP_TARGET = "http.target";
    private static final String HTTP_ROUTE = "http.route";
    private static final String SPAN_NAME_FULL_URL = "telemetry.span.full.url";
    private static final String HELPER_START_SPAN_PROPERTY = String.valueOf(HelidonTelemetryContainerFilterHelper.class) + ".startSpan";
    @Deprecated(forRemoval=true, since="4.1")
    static final String SPAN_NAME_INCLUDES_METHOD = "telemetry.span.name-includes-method";
    private static boolean spanNameFullUrl = false;
    private static AtomicBoolean spanNameWarningLogged = new AtomicBoolean();
    private final Tracer helidonTracer;
    private final boolean isAgentPresent;
    private final boolean restSpanNameIncludesMethod;
    private final List<HelidonTelemetryContainerFilterHelper> helpers;
    @jakarta.ws.rs.core.Context
    private ResourceInfo resourceInfo;

    @Inject
    HelidonTelemetryContainerFilter(Tracer helidonTracer, org.eclipse.microprofile.config.Config mpConfig, Instance<HelidonTelemetryContainerFilterHelper> helpersInstance) {
        this.helidonTracer = helidonTracer;
        this.isAgentPresent = HelidonOpenTelemetry.AgentDetector.isAgentPresent((Config)MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)mpConfig));
        mpConfig.getOptionalValue(SPAN_NAME_FULL_URL, Boolean.class).ifPresent(e -> {
            spanNameFullUrl = e;
        });
        Optional includeMethodConfig = mpConfig.getOptionalValue(SPAN_NAME_INCLUDES_METHOD, Boolean.class);
        this.restSpanNameIncludesMethod = includeMethodConfig.orElse(false);
        if (!this.restSpanNameIncludesMethod && !spanNameWarningLogged.get()) {
            spanNameWarningLogged.set(true);
            LOGGER.log(System.Logger.Level.WARNING, String.format("Current OpenTelemetry semantic conventions include the HTTP method as part of REST span\nnames. Your configuration does not set %s to true, so your service uses the legacy span name\nformat which excludes the HTTP method. This feature is deprecated and marked for removal in a\nfuture major release of Helidon. Consider adding a setting of %1$s to 'true' in your\nconfiguration to migrate to the current conventions.", SPAN_NAME_INCLUDES_METHOD));
        }
        this.helpers = helpersInstance.stream().toList();
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.isAgentPresent) {
            return;
        }
        boolean startSpan = this.helpers.stream().allMatch(h -> h.shouldStartSpan(requestContext));
        requestContext.setProperty(HELPER_START_SPAN_PROPERTY, (Object)startSpan);
        if (!startSpan) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Container filter helper(s) voted to not start a span for " + String.valueOf(requestContext));
            }
            return;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Starting Span in a Container Request");
        }
        String route = this.route(requestContext);
        Optional<SpanContext> parentSpanContext = this.parentSpanContext(requestContext);
        Span helidonSpan = ((Span.Builder)this.helidonTracer.spanBuilder(this.spanName(requestContext, route)).kind(Span.Kind.SERVER).tag("http.method", requestContext.getMethod()).tag("http.scheme", requestContext.getUriInfo().getRequestUri().getScheme()).tag(HTTP_TARGET, this.resolveTarget(requestContext)).tag(HTTP_ROUTE, route).tag(SemanticAttributes.NET_HOST_NAME.getKey(), requestContext.getUriInfo().getBaseUri().getHost()).tag(SemanticAttributes.NET_HOST_PORT.getKey(), (Number)requestContext.getUriInfo().getBaseUri().getPort()).update(builder -> parentSpanContext.ifPresent(arg_0 -> ((Span.Builder)builder).parent(arg_0)))).start();
        Scope helidonScope = helidonSpan.activate();
        requestContext.setProperty(SPAN, (Object)helidonSpan);
        requestContext.setProperty(SPAN_SCOPE, (Object)helidonScope);
        this.handleBaggage(requestContext, Context.current());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        if (this.isAgentPresent) {
            return;
        }
        Boolean startSpanObj = (Boolean)request.getProperty(HELPER_START_SPAN_PROPERTY);
        if (startSpanObj != null && !startSpanObj.booleanValue()) {
            return;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Closing Span in a Container Request");
        }
        try {
            Span span = (Span)request.getProperty(SPAN);
            if (span == null) {
                return;
            }
            Scope scope = (Scope)request.getProperty(SPAN_SCOPE);
            scope.close();
            span.tag("http.status_code", (Number)response.getStatus());
            if (response.getStatusInfo().getFamily().compareTo((Enum)Response.Status.Family.SERVER_ERROR) == 0) {
                span.status(Span.Status.ERROR);
            }
            span.end();
        }
        finally {
            request.removeProperty(SPAN);
            request.removeProperty(SPAN_SCOPE);
        }
    }

    private Optional<SpanContext> parentSpanContext(ContainerRequestContext requestContext) {
        return Span.current().map(Span::context).or(() -> this.helidonTracer.extract((HeaderProvider)new RequestContextHeaderProvider((MultivaluedMap<String, String>)requestContext.getHeaders())));
    }

    private String spanName(ContainerRequestContext requestContext, String route) {
        return (String)(this.restSpanNameIncludesMethod ? requestContext.getMethod() + " " : "") + (spanNameFullUrl ? requestContext.getUriInfo().getAbsolutePath().toString() : route);
    }

    private String route(ContainerRequestContext requestContext) {
        ExtendedUriInfo extendedUriInfo = (ExtendedUriInfo)requestContext.getUriInfo();
        LinkedList<String> derivedPath = new LinkedList<String>();
        for (Resource resource = extendedUriInfo.getMatchedModelResource(); resource != null; resource = resource.getParent()) {
            String resourcePath = resource.getPath();
            if (resourcePath == null || resourcePath.equals("/") || resourcePath.isBlank()) continue;
            derivedPath.push(resourcePath);
            if (resourcePath.startsWith("/")) continue;
            derivedPath.push("/");
        }
        derivedPath.push(this.applicationPath());
        return String.join((CharSequence)"", derivedPath);
    }

    private String applicationPath() {
        Application app = (Application)Contexts.context().flatMap(it -> it.get(Application.class)).orElseThrow(() -> new IllegalStateException("Application missing from context"));
        if (app == null) {
            return "";
        }
        ApplicationPath applicationPath = HelidonTelemetryContainerFilter.getRealClass(app.getClass()).getAnnotation(ApplicationPath.class);
        return applicationPath == null || applicationPath.value().equals("/") ? "" : applicationPath.value();
    }

    private String resolveTarget(ContainerRequestContext requestContext) {
        String path = requestContext.getUriInfo().getRequestUri().getPath();
        String rawQuery = requestContext.getUriInfo().getRequestUri().getRawQuery();
        if (rawQuery != null && !rawQuery.isEmpty()) {
            return path + "?" + rawQuery;
        }
        return path;
    }

    private void handleBaggage(ContainerRequestContext containerRequestContext, Context context) {
        List baggageProperties = (List)containerRequestContext.getHeaders().get((Object)"baggage");
        if (baggageProperties != null) {
            BaggageBuilder baggageBuilder = Baggage.builder();
            for (String b : baggageProperties) {
                String[] split = b.split("=");
                if (split.length != 2) continue;
                String[] valueAndMetadata = split[1].split(";");
                String value = valueAndMetadata.length > 0 ? valueAndMetadata[0] : "";
                String metadata = valueAndMetadata.length > 1 ? valueAndMetadata[1] : "";
                baggageBuilder.put(split[0], value, BaggageEntryMetadata.create((String)metadata));
            }
            baggageBuilder.build().storeInContext(context).makeCurrent();
        }
    }

    private static Class<?> getRealClass(Class<?> object) {
        Class<?> result = object;
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }
}

