/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.telemetry;

import io.helidon.config.Config;
import io.helidon.microprofile.telemetry.CallbackEnabled;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetryTracerProvider;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

@ApplicationScoped
class OpenTelemetryProducer {
    private static final System.Logger LOGGER = System.getLogger(OpenTelemetryProducer.class.getName());
    private static final String HELIDON_SERVICE_NAME = "HELIDON_MICROPROFILE_TELEMETRY";
    private static final String SERVICE_NAME = "service.name";
    private static final String ENV_OTEL_SDK_DISABLED = "OTEL_SDK_DISABLED";
    private static final String OTEL_SDK_DISABLED = "otel.sdk.disabled";
    private static final String OTEL_METRICS_EXPORTER = "otel.metrics.exporter";
    private static final String OTEL_LOGS_EXPORTER = "otel.logs.exporter";
    private static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    private static final String EXPORTER_NAME_PROPERTY = "otel.exporter.name";
    private String exporterName = "HELIDON_MICROPROFILE_TELEMETRY";
    private OpenTelemetry openTelemetry;
    private Map<String, String> telemetryProperties;
    private final Config config;
    private volatile io.opentelemetry.api.trace.Tracer tracer;
    private volatile Tracer helidonTracer;
    private final org.eclipse.microprofile.config.Config mpConfig;

    @Inject
    OpenTelemetryProducer(Config config, org.eclipse.microprofile.config.Config mpConfig) {
        this.config = config;
        this.mpConfig = mpConfig;
    }

    @PostConstruct
    private void init() {
        this.telemetryProperties = Collections.unmodifiableMap(this.getTelemetryProperties());
        this.mpConfig.getOptionalValue(EXPORTER_NAME_PROPERTY, String.class).ifPresent(e -> {
            this.exporterName = e;
        });
        if (HelidonOpenTelemetry.AgentDetector.useExistingGlobalOpenTelemetry((Config)this.config)) {
            this.openTelemetry = GlobalOpenTelemetry.get();
        } else if (!this.isTelemetryDisabled()) {
            this.openTelemetry = AutoConfiguredOpenTelemetrySdk.builder().addPropertiesCustomizer(x -> this.telemetryProperties).addResourceCustomizer(this::customizeResource).setServiceClassLoader(Thread.currentThread().getContextClassLoader()).disableShutdownHook().build().getOpenTelemetrySdk();
            if (this.openTelemetry != null) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Telemetry Auto Configured");
                }
            } else {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Telemetry Disabled");
                }
                this.openTelemetry = OpenTelemetry.noop();
            }
        } else {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Telemetry Disabled by configuration");
            }
            this.openTelemetry = OpenTelemetry.noop();
        }
        this.tracer = this.openTelemetry.getTracer(this.exporterName);
        this.helidonTracer = HelidonOpenTelemetry.create((OpenTelemetry)this.openTelemetry, (io.opentelemetry.api.trace.Tracer)this.tracer, Map.of());
        OpenTelemetryTracerProvider.globalTracer((Tracer)this.helidonTracer);
    }

    @ApplicationScoped
    @Produces
    OpenTelemetry openTelemetry() {
        return this.openTelemetry;
    }

    @Produces
    io.opentelemetry.api.trace.Tracer tracer() {
        return this.tracer;
    }

    @Produces
    @CallbackEnabled
    io.opentelemetry.api.trace.Tracer callbackEnabledTracer() {
        return HelidonOpenTelemetry.callbackEnabledFrom((Tracer)this.helidonTracer);
    }

    @Produces
    Tracer helidonTracer() {
        return this.helidonTracer;
    }

    @Produces
    Span span() {
        return new Span(this){

            public <T> Span setAttribute(AttributeKey<T> key, T value) {
                return Span.current().setAttribute(key, value);
            }

            public Span addEvent(String name, Attributes attributes) {
                return Span.current().addEvent(name, attributes);
            }

            public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
                return Span.current().addEvent(name, attributes, timestamp, unit);
            }

            public Span setStatus(StatusCode statusCode, String description) {
                return Span.current().setStatus(statusCode, description);
            }

            public Span recordException(Throwable exception, Attributes additionalAttributes) {
                return Span.current().recordException(exception, additionalAttributes);
            }

            public Span updateName(String name) {
                return Span.current().updateName(name);
            }

            public void end() {
                Span.current().end();
            }

            public void end(long timestamp, TimeUnit unit) {
                Span.current().end(timestamp, unit);
            }

            public SpanContext getSpanContext() {
                return Span.current().getSpanContext();
            }

            public boolean isRecording() {
                return Span.current().isRecording();
            }
        };
    }

    @Produces
    @CallbackEnabled
    Span callbackEnabledSpan() {
        return (Span)io.helidon.tracing.Span.current().map(HelidonOpenTelemetry::callbackEnabledFrom).orElse(HelidonOpenTelemetry.callbackEnabledFrom((Span)this.span()));
    }

    @Produces
    @ApplicationScoped
    Baggage baggage() {
        return new Baggage(this){

            public int size() {
                return Baggage.current().size();
            }

            public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
                Baggage.current().forEach(consumer);
            }

            public Map<String, BaggageEntry> asMap() {
                return Baggage.current().asMap();
            }

            public String getEntryValue(String entryKey) {
                return Baggage.current().getEntryValue(entryKey);
            }

            public BaggageBuilder toBuilder() {
                return Baggage.current().toBuilder();
            }
        };
    }

    private Map<String, String> getTelemetryProperties() {
        HashMap<String, String> telemetryProperties = new HashMap<String, String>();
        for (String propertyName : this.mpConfig.getPropertyNames()) {
            if (!propertyName.startsWith("otel.")) continue;
            this.mpConfig.getOptionalValue(propertyName, String.class).ifPresent(value -> telemetryProperties.put(propertyName, (String)value));
        }
        telemetryProperties.putIfAbsent(OTEL_METRICS_EXPORTER, "none");
        telemetryProperties.putIfAbsent(OTEL_LOGS_EXPORTER, "none");
        return telemetryProperties;
    }

    private boolean isTelemetryDisabled() {
        if (this.telemetryProperties.get(ENV_OTEL_SDK_DISABLED) != null) {
            return Boolean.parseBoolean(this.telemetryProperties.get(ENV_OTEL_SDK_DISABLED));
        }
        if (this.telemetryProperties.get(OTEL_SDK_DISABLED) != null) {
            return Boolean.parseBoolean(this.telemetryProperties.get(OTEL_SDK_DISABLED));
        }
        return true;
    }

    private Resource customizeResource(Resource resource, ConfigProperties c) {
        return resource.toBuilder().put(SERVICE_NAME, this.getServiceName(c)).build();
    }

    private String getServiceName(ConfigProperties c) {
        return c.getString(SERVICE_NAME_PROPERTY, HELIDON_SERVICE_NAME);
    }
}

