/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.telemetry;

import io.helidon.microprofile.telemetry.HelidonWithSpan;
import io.helidon.microprofile.telemetry.OpenTelemetryProducer;
import io.helidon.microprofile.telemetry.WithSpanInterceptor;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;

public class TelemetryCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(TelemetryCdiExtension.class.getName());

    void before(@Observes BeforeBeanDiscovery discovery) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Before Telemetry bean discovery " + String.valueOf(discovery));
        discovery.addAnnotatedType(HelidonWithSpan.class, HelidonWithSpan.class.getName());
        discovery.addAnnotatedType(WithSpanInterceptor.class, WithSpanInterceptor.class.getName());
        discovery.addAnnotatedType(OpenTelemetryProducer.class, OpenTelemetryProducer.class.getName());
    }

    void processAnnotations(@Observes @WithAnnotations(value={WithSpan.class}) ProcessAnnotatedType<?> pat) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Process WithSpan annotation and add binding" + String.valueOf(pat));
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        for (AnnotatedMethodConfigurator method : configurator.methods()) {
            WithSpan withSpan = (WithSpan)method.getAnnotated().getAnnotation(WithSpan.class);
            if (withSpan == null) continue;
            method.add((Annotation)HelidonWithSpan.Literal.INSTANCE);
        }
    }

    void finish(@Observes @Priority(value=1000) @Initialized(value=ApplicationScoped.class) Object startup, io.helidon.tracing.Tracer tracer) {
        tracer.enabled();
        LOGGER.log(System.Logger.Level.TRACE, () -> "Global tracer set to " + String.valueOf(tracer.unwrap(Tracer.class)));
    }
}

