/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.telemetry;

import io.helidon.config.Config;
import io.helidon.microprofile.telemetry.HelidonWithSpan;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

@Interceptor
@Priority(value=7)
@HelidonWithSpan
class WithSpanInterceptor {
    private static final System.Logger LOGGER = System.getLogger(WithSpanInterceptor.class.getName());
    private final Tracer tracer;
    private final boolean isAgentPresent;

    @Inject
    WithSpanInterceptor(Tracer tracer, Config config) {
        this.tracer = tracer;
        this.isAgentPresent = HelidonOpenTelemetry.AgentDetector.isAgentPresent((Config)config);
    }

    @AroundInvoke
    public Object interceptSpan(InvocationContext context) throws Exception {
        Object object;
        block17: {
            Method method;
            WithSpan annotation;
            Object spanName;
            if (this.isAgentPresent) {
                return context.proceed();
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Starting new Span on WithSpan annotated method");
            }
            if (((String)(spanName = (annotation = (method = context.getMethod()).getAnnotation(WithSpan.class)).value())).isEmpty()) {
                String className = method.getDeclaringClass().getName();
                if (className.contains("$")) {
                    className = className.substring(className.lastIndexOf("$") + 1);
                }
                spanName = className + "." + method.getName();
            }
            Span.Builder helidonSpanBuilder = this.tracer.spanBuilder((String)spanName).kind(Span.Kind.INTERNAL);
            Span.current().map(Span::context).ifPresent(arg_0 -> ((Span.Builder)helidonSpanBuilder).parent(arg_0));
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                if (!p.isAnnotationPresent(SpanAttribute.class)) continue;
                SpanAttribute spanAttribute = p.getAnnotation(SpanAttribute.class);
                String attrName = spanAttribute.value().isBlank() ? p.getName() : spanAttribute.value();
                Class<?> paramType = p.getType();
                Object pValue = context.getParameters()[i];
                if (String.class.isAssignableFrom(paramType)) {
                    helidonSpanBuilder.tag(attrName, (String)pValue);
                    continue;
                }
                if (Long.class.isAssignableFrom(paramType) || Long.TYPE.isAssignableFrom(paramType)) {
                    helidonSpanBuilder.tag(attrName, (Number)((Long)pValue));
                    continue;
                }
                if (Double.class.isAssignableFrom(paramType) || Double.TYPE.isAssignableFrom(paramType)) {
                    helidonSpanBuilder.tag(attrName, (Number)((Double)pValue));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(paramType) || Boolean.TYPE.isAssignableFrom(paramType)) {
                    helidonSpanBuilder.tag(attrName, (Boolean)pValue);
                    continue;
                }
                helidonSpanBuilder.tag(attrName, pValue.toString());
            }
            Span helidonSpan = helidonSpanBuilder.start();
            Scope ignored = helidonSpan.activate();
            try {
                Object result = context.proceed();
                helidonSpan.end();
                object = result;
                if (ignored == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    helidonSpan.end((Throwable)e);
                    throw e;
                }
            }
            ignored.close();
        }
        return object;
    }
}

