/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.config.mp.MpConfigSources;
import io.helidon.microprofile.testing.HelidonTestConfigDelegate;
import io.helidon.microprofile.testing.HelidonTestConfigSynthetic;
import io.helidon.microprofile.testing.HelidonTestInfo;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

class HelidonTestConfig
extends HelidonTestConfigDelegate {
    private final HelidonTestConfigSynthetic syntheticConfig;
    private final Config originalConfig;
    private volatile Config delegate;

    HelidonTestConfig(HelidonTestInfo<?> testInfo) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ConfigProviderResolver resolver = ConfigProviderResolver.instance();
        this.originalConfig = resolver.getConfig(cl);
        resolver.releaseConfig(this.originalConfig);
        this.delegate = resolver.getBuilder().withSources(new ConfigSource[]{MpConfigSources.create(Map.of("mp.initializer.allow", "true", "mp.initializer.no-warn", "true"))}).build();
        this.syntheticConfig = new HelidonTestConfigSynthetic(testInfo, this::refresh);
        resolver.registerConfig((Config)this, cl);
    }

    @Override
    Config delegate() {
        return this.delegate;
    }

    HelidonTestConfigSynthetic synthetic() {
        return this.syntheticConfig;
    }

    void resolve() {
        this.delegate = this.syntheticConfig.useExisting() ? this.originalConfig : this.syntheticConfig;
    }

    void restore() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ConfigProviderResolver resolver = ConfigProviderResolver.instance();
        resolver.registerConfig(this.originalConfig, cl);
    }
}

