/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.jersey.common.InvokedResource;
import io.helidon.microprofile.tracing.MpTracingHelper;
import io.helidon.tracing.jersey.AbstractTracingFilter;
import io.opentracing.Tracer;
import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.opentracing.Traced;

@ConstrainedTo(value=RuntimeType.SERVER)
@Priority(value=-2147483643)
@ApplicationScoped
public class MpTracingFilter
extends AbstractTracingFilter {
    private static final Pattern LOCALHOST_PATTERN = Pattern.compile("127.0.0.1", 16);
    @Context
    private ResourceInfo resourceInfo;
    private MpTracingHelper utils;
    private Function<String, Boolean> skipPatternFunction;

    @PostConstruct
    public void postConstruct() {
        this.utils = MpTracingHelper.create();
        Config config = ConfigProvider.getConfig();
        Optional skipPattern = config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class);
        this.skipPatternFunction = skipPattern.map(Pattern::compile).map(pattern -> path -> pattern.matcher((CharSequence)path).matches()).orElse(path -> false);
    }

    protected boolean tracingEnabled(ContainerRequestContext context) {
        if (this.skipPatternFunction.apply(this.addForwardSlash(context.getUriInfo().getPath())).booleanValue()) {
            return false;
        }
        return InvokedResource.create((ContainerRequestContext)context).findAnnotation(Traced.class).map(Traced::value).orElseGet(this.utils::tracingEnabled);
    }

    private String addForwardSlash(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        if (path.charAt(0) == '/') {
            return path;
        }
        return "/" + path;
    }

    protected String spanName(ContainerRequestContext context) {
        return InvokedResource.create((ContainerRequestContext)context).findAnnotation(Traced.class).map(Traced::operationName).filter(str -> !str.isEmpty()).orElseGet(() -> this.utils.operationName(context));
    }

    protected void configureSpan(Tracer.SpanBuilder spanBuilder) {
    }

    protected String url(ContainerRequestContext requestContext) {
        String hostHeader = requestContext.getHeaderString("host");
        URI requestUri = requestContext.getUriInfo().getRequestUri();
        if (null != hostHeader) {
            Object query = requestUri.getQuery();
            if (null == query) {
                query = "";
            } else if (!((String)query).isEmpty()) {
                query = "?" + (String)query;
            }
            if (hostHeader.contains("127.0.0.1")) {
                hostHeader = LOCALHOST_PATTERN.matcher(hostHeader).replaceAll(Matcher.quoteReplacement("localhost"));
            }
            return requestUri.getScheme() + "://" + hostHeader + requestUri.getPath() + (String)query;
        }
        return requestUri.toString();
    }
}

