/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.tracing.jersey.TracingHelper;
import java.util.function.Function;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

final class MpTracingHelper {
    private static final String NAME_PROVIDER_HTTP_PATH = "http-path";
    private static final String NAME_PROVIDER_CLASS_METHOD = "class-method";
    private static final String DEFAULT_NAME_PROVIDER = "class-method";
    private static final String PROPERTY_NAME_PROVIDER = "mp.opentracing.server.operation-name-provider";
    private static final String PROPERTY_ENABLED = "tracing.enabled";
    private final Function<ContainerRequestContext, String> nameFunction;
    private final boolean enabled;

    private MpTracingHelper(Function<ContainerRequestContext, String> nameFunction, boolean enabled) {
        this.nameFunction = nameFunction;
        this.enabled = enabled;
    }

    static MpTracingHelper create() {
        Function<ContainerRequestContext, String> nameFunction;
        String nameProvider;
        Config config = ConfigProvider.getConfig();
        switch (nameProvider = config.getOptionalValue(PROPERTY_NAME_PROVIDER, String.class).orElse("class-method")) {
            case "http-path": {
                nameFunction = TracingHelper::httpPathMethodName;
                break;
            }
            default: {
                nameFunction = TracingHelper::classMethodName;
            }
        }
        boolean enabled = config.getOptionalValue(PROPERTY_ENABLED, Boolean.class).orElse(true);
        return new MpTracingHelper(nameFunction, enabled);
    }

    String operationName(ContainerRequestContext requestContext) {
        return this.nameFunction.apply(requestContext);
    }

    public boolean tracingEnabled() {
        return this.enabled;
    }
}

