/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.tracing.jersey.client.ClientTracingFilter;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.eclipse.microprofile.opentracing.Traced;

@Priority(value=650)
public class MpTracingRestClientFilter
implements ClientRequestFilter {
    private static final String INVOKED_METHOD = "org.eclipse.microprofile.rest.client.invokedMethod";

    public void filter(ClientRequestContext requestContext) {
        Method invokedMethod = (Method)requestContext.getProperty(INVOKED_METHOD);
        if (null == invokedMethod) {
            return;
        }
        Traced traced = invokedMethod.getAnnotation(Traced.class);
        if (null == traced) {
            return;
        }
        boolean enabled = traced.value();
        String opName = traced.operationName();
        if (!opName.isEmpty()) {
            requestContext.setProperty(ClientTracingFilter.SPAN_NAME_PROPERTY_NAME, (Object)opName);
        }
        requestContext.setProperty(ClientTracingFilter.ENABLED_PROPERTY_NAME, (Object)enabled);
    }
}

