/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.tracing.MpTracingFilter;
import io.helidon.microprofile.tracing.MpTracingInterceptor;
import io.helidon.microprofile.tracing.TracerProducer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.webserver.WebTracingConfig;
import io.opentracing.Tracer;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.eclipse.microprofile.config.ConfigProvider;

public class TracingCdiExtension
implements Extension {
    private void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        bbd.addAnnotatedType(MpTracingInterceptor.class, "TracingInterceptor");
        bbd.addAnnotatedType(TracerProducer.class, "TracingTracerProducer");
    }

    private void prepareTracer(@Observes @Priority(value=11) @Initialized(value=ApplicationScoped.class) Object event, BeanManager bm) {
        JaxRsCdiExtension jaxrs = (JaxRsCdiExtension)bm.getExtension(JaxRsCdiExtension.class);
        ServerCdiExtension server = (ServerCdiExtension)bm.getExtension(ServerCdiExtension.class);
        Config config = ((Config)ConfigProvider.getConfig()).get("tracing");
        List jaxRsApps = jaxrs.applicationsToRun();
        String serviceName = jaxrs.serviceName();
        Tracer tracer = TracerBuilder.create((String)serviceName).config(config).build();
        Contexts.globalContext().register((Object)tracer);
        server.serverBuilder().tracer(tracer);
        Contexts.context().ifPresent(ctx -> ctx.register((Object)tracer));
        if (tracer.getClass().getName().startsWith("io.opentracing.noop")) {
            Logger.getLogger(TracingCdiExtension.class.getName()).warning("helidon-microprofile-tracing is on the classpath, yet there is no tracer implementation library. Tracing uses a no-op tracer. As a result, no tracing will be configured for WebServer and JAX-RS");
            return;
        }
        server.serverRoutingBuilder().register(WebTracingConfig.create((Config)config));
        jaxRsApps.forEach(app -> app.resourceConfig().register(MpTracingFilter.class));
    }
}

