/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.common.context.Contexts;
import io.helidon.tracing.jersey.client.ClientTracingFilter;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.Path;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.opentracing.Traced;

@Interceptor
@Traced
@Priority(value=7)
public class MpTracingInterceptor {
    @Inject
    private Tracer tracer;

    @AroundInvoke
    private Object aroundMethod(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        return this.trace(context, method, method.getDeclaringClass());
    }

    private <E extends Member & AnnotatedElement> Object trace(InvocationContext context, E element, Class<?> declaringClass) throws Exception {
        if (null != declaringClass.getAnnotation(Path.class)) {
            return context.proceed();
        }
        Traced annotation = ((AnnotatedElement)element).getAnnotation(Traced.class);
        if (null == annotation && null == (annotation = declaringClass.getAnnotation(Traced.class))) {
            return context.proceed();
        }
        if (annotation.value()) {
            String newName = annotation.operationName();
            if (newName.isEmpty()) {
                newName = this.spanName(declaringClass, element);
            }
            Tracer tracer = this.locateTracer();
            Optional<SpanContext> parentSpan = this.locateParent();
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(newName);
            parentSpan.ifPresent(arg_0 -> ((Tracer.SpanBuilder)spanBuilder).asChildOf(arg_0));
            Span span = spanBuilder.start();
            Scope scope = tracer.scopeManager().activate(span);
            try {
                Object object = context.proceed();
                return object;
            }
            catch (Exception e) {
                span.setTag("error", true);
                span.log(Map.of("error.object", e.getClass().getName(), "event", "error"));
                throw e;
            }
            finally {
                span.finish();
                scope.close();
            }
        }
        return context.proceed();
    }

    private <E extends Member & AnnotatedElement> String spanName(Class<?> declaringClass, E element) {
        return declaringClass.getName() + "." + element.getName();
    }

    private Optional<SpanContext> locateParent() {
        Span active = this.tracer.activeSpan();
        if (null != active) {
            return Optional.of(active.context());
        }
        Optional context = Contexts.context();
        return context.flatMap(ctx -> ctx.get(SpanContext.class)).or(() -> context.flatMap(ctx -> ctx.get(ClientTracingFilter.class, SpanContext.class)));
    }

    private Tracer locateTracer() {
        return Contexts.context().flatMap(ctx -> ctx.get(Tracer.class)).orElseGet(GlobalTracer::get);
    }
}

