/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.tracing.MpTracingFilter;
import io.helidon.microprofile.tracing.MpTracingInterceptor;
import io.helidon.microprofile.tracing.TracerProducer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.webserver.WebTracingConfig;
import io.opentelemetry.opentracingshim.OpenTracingShim;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import java.util.List;
import java.util.logging.Logger;

public class TracingCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(TracingCdiExtension.class.getName());
    private io.helidon.tracing.Tracer tracer;
    private Config config;

    private void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        bbd.addAnnotatedType(MpTracingInterceptor.class, "TracingInterceptor");
        bbd.addAnnotatedType(TracerProducer.class, "TracingTracerProducer");
    }

    private void setupTracer(@Observes @Priority(value=0) @RuntimeStart Config rootConfig, BeanManager bm) {
        Tracer registeredTracer;
        String serviceName = ((JaxRsCdiExtension)bm.getExtension(JaxRsCdiExtension.class)).serviceName();
        this.config = rootConfig.get("tracing");
        this.tracer = (io.helidon.tracing.Tracer)TracerBuilder.create((String)serviceName).config(this.config).build();
        if (!this.tracer.enabled()) {
            LOGGER.warning("helidon-microprofile-tracing is on the classpath, yet there is no tracer implementation library or tracing is explicitly disabled. Tracing uses a no-op tracer. As a result, no tracing will be configured for WebServer and JAX-RS");
            Contexts.globalContext().register((Object)io.helidon.tracing.Tracer.noOp());
            Contexts.globalContext().register((Object)GlobalTracer.get());
            return;
        }
        try {
            registeredTracer = (Tracer)this.tracer.unwrap(Tracer.class);
        }
        catch (Exception e) {
            try {
                io.opentelemetry.api.trace.Tracer otelTracer = (io.opentelemetry.api.trace.Tracer)this.tracer.unwrap(io.opentelemetry.api.trace.Tracer.class);
                registeredTracer = OpenTracingShim.createTracerShim((io.opentelemetry.api.trace.Tracer)otelTracer);
            }
            catch (Exception ex) {
                throw new DeploymentException("MicroProfile tracing requires an OpenTracing or OpenTelemetry based tracer", (Throwable)ex);
            }
        }
        Tracer openTracingTracer = registeredTracer;
        Contexts.globalContext().register((Object)openTracingTracer);
        Contexts.globalContext().register((Object)this.tracer);
        Contexts.context().ifPresent(ctx -> ctx.register((Object)openTracingTracer));
    }

    private void serverTracer(@Observes @Priority(value=1) @Initialized(value=ApplicationScoped.class) Object event, BeanManager bm) {
        ServerCdiExtension server = (ServerCdiExtension)bm.getExtension(ServerCdiExtension.class);
        server.serverBuilder().tracer(this.tracer);
        if (!this.tracer.enabled()) {
            return;
        }
        JaxRsCdiExtension jaxrs = (JaxRsCdiExtension)bm.getExtension(JaxRsCdiExtension.class);
        server.serverRoutingBuilder().register(WebTracingConfig.create((Config)this.config));
        List jaxRsApps = jaxrs.applicationsToRun();
        jaxRsApps.forEach(app -> app.resourceConfig().register(MpTracingFilter.class));
    }
}

