/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.tracing.jersey.client.ClientTracingFilter;
import jakarta.ws.rs.client.ClientBuilder;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrarProvider;

public class MpTracingClientRegistrar
implements ClientTracingRegistrarProvider {
    private static final ClientTracingFilter FILTER = new ClientTracingFilter();
    static final ThreadPoolSupplier EXECUTOR_SERVICE;

    public ClientBuilder configure(ClientBuilder clientBuilder) {
        return this.configure(clientBuilder, EXECUTOR_SERVICE.get());
    }

    public ClientBuilder configure(ClientBuilder clientBuilder, ExecutorService executorService) {
        clientBuilder.register((Object)FILTER);
        clientBuilder.executorService(Contexts.wrap((ExecutorService)executorService));
        return clientBuilder;
    }

    static {
        Config config = (Config)ConfigProvider.getConfig();
        EXECUTOR_SERVICE = ThreadPoolSupplier.create((io.helidon.common.config.Config)config.get("tracing.executor-service"), (String)"mp-tracing-thread-pool");
    }
}

