/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.common.context.Contexts;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.jersey.client.internal.TracingContext;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Provider;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
@Priority(value=-2147483648)
@ApplicationScoped
public class MpTracingContextFilter
implements ContainerRequestFilter {
    private final Provider<ServerRequest> request;
    private final Config config = ConfigProvider.getConfig();

    public MpTracingContextFilter(@Context Provider<ServerRequest> request) {
        this.request = request;
    }

    public void filter(ContainerRequestContext requestContext) {
        ServerRequest serverRequest = (ServerRequest)this.request.get();
        Tracer tracer = serverRequest.context().get(Tracer.class).orElseGet(Tracer::global);
        Optional<SpanContext> parentSpan = Span.current().map(Span::context);
        boolean clientEnabled = this.config.getOptionalValue("tracing.client.enabled", Boolean.class).orElse(true);
        TracingContext tracingContext = TracingContext.create((Tracer)tracer, (Map)serverRequest.headers().toMap(), (boolean)clientEnabled);
        parentSpan.ifPresent(arg_0 -> ((TracingContext)tracingContext).parentSpan(arg_0));
        Contexts.context().ifPresent(ctx -> ctx.register((Object)tracingContext));
    }
}

