/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tracing;

import io.helidon.microprofile.tracing.MpTracingRestClientFilter;
import io.helidon.tracing.jersey.client.ClientTracingFilter;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class MpTracingRestClientListener
implements RestClientListener {
    private static final ClientTracingFilter FILTER = new ClientTracingFilter();
    private static final MpTracingRestClientFilter REST_CLIENT_FILTER = new MpTracingRestClientFilter();

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        String opName;
        boolean enabled;
        Traced traced = serviceInterface.getAnnotation(Traced.class);
        if (null != traced) {
            enabled = traced.value();
            opName = traced.operationName();
        } else {
            enabled = true;
            opName = "";
        }
        builder.register((Object)REST_CLIENT_FILTER, 700);
        builder.register((Object)FILTER, 750);
        if (!opName.isEmpty()) {
            builder.property(ClientTracingFilter.SPAN_NAME_PROPERTY_NAME, (Object)opName);
        }
        builder.property(ClientTracingFilter.ENABLED_PROPERTY_NAME, (Object)enabled);
    }
}

