/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.common.tls;

import io.helidon.nima.common.tls.Tls;
import io.helidon.nima.common.tls.TlsReloadableComponent;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.X509KeyManager;

class ReloadableX509KeyManager
implements X509KeyManager,
TlsReloadableComponent {
    private static final System.Logger LOGGER = System.getLogger(ReloadableX509KeyManager.class.getName());
    private volatile X509KeyManager keyManager;

    ReloadableX509KeyManager(X509KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.keyManager.getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManager.chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.keyManager.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.keyManager.chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.keyManager.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.keyManager.getPrivateKey(s);
    }

    @Override
    public void reload(Tls tls) {
        Objects.requireNonNull(tls.originalKeyManager(), "Cannot unset key manager");
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Reloading TLS X509KeyManager");
        }
        this.keyManager = tls.originalKeyManager();
    }

    static class NotReloadableKeyManager
    implements TlsReloadableComponent {
        NotReloadableKeyManager() {
        }

        @Override
        public void reload(Tls tls) {
            if (tls.originalKeyManager() != null) {
                throw new UnsupportedOperationException("Cannot reload key manager if one was not set during server start");
            }
        }
    }
}

