/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.common.tls;

import io.helidon.nima.common.tls.Tls;
import io.helidon.nima.common.tls.TlsReloadableComponent;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.X509TrustManager;

class ReloadableX509TrustManager
implements X509TrustManager,
TlsReloadableComponent {
    private static final System.Logger LOGGER = System.getLogger(ReloadableX509TrustManager.class.getName());
    private volatile X509TrustManager trustManager;

    ReloadableX509TrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void reload(Tls tls) {
        Objects.requireNonNull(tls.originalKeyManager(), "Cannot unset trust store");
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Reloading TLS X509TrustManager");
        }
        this.trustManager = tls.originalTrustManager();
    }

    static class NotReloadableTrustManager
    implements TlsReloadableComponent {
        NotReloadableTrustManager() {
        }

        @Override
        public void reload(Tls tls) {
            if (tls.originalTrustManager() != null) {
                throw new UnsupportedOperationException("Cannot set trust manager if one was not set during server start");
            }
        }
    }
}

