/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.common.tls;

import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.pki.KeyConfig;
import io.helidon.nima.common.tls.ReloadableX509KeyManager;
import io.helidon.nima.common.tls.ReloadableX509TrustManager;
import io.helidon.nima.common.tls.TlsClientAuth;
import io.helidon.nima.common.tls.TlsReloadableComponent;
import io.helidon.nima.common.tls.TrustAllManagerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract sealed class Tls {
    public static final String ENDPOINT_IDENTIFICATION_HTTPS = "HTTPS";
    public static final String ENDPOINT_IDENTIFICATION_NONE = "NONE";
    private static final LazyValue<SecureRandom> RANDOM = LazyValue.create(SecureRandom::new);
    private final SSLContext sslContext;
    private final SSLParameters sslParameters;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLServerSocketFactory sslServerSocketFactory;
    private final List<TlsReloadableComponent> reloadableComponents;
    private final X509TrustManager originalTrustManager;
    private final X509KeyManager originalKeyManager;
    private final boolean enabled;

    private Tls(Builder builder) {
        this.sslContext = builder.sslContext;
        this.sslParameters = builder.sslParameters;
        this.sslSocketFactory = this.sslContext.getSocketFactory();
        this.sslServerSocketFactory = this.sslContext.getServerSocketFactory();
        this.enabled = builder.enabled;
        this.reloadableComponents = List.copyOf(builder.reloadableComponents);
        this.originalTrustManager = builder.originalTrustManager;
        this.originalKeyManager = builder.originalKeyManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Tls create(Config config) {
        return Tls.builder().config(config).build();
    }

    public final SSLEngine newEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setSSLParameters(this.sslParameters);
        return sslEngine;
    }

    public int hashCode() {
        return 31 * Objects.hash(this.sslContext) + Tls.hashCode(this.sslParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tls)) {
            return false;
        }
        Tls tlsConfig = (Tls)o;
        return this.sslContext.equals(tlsConfig.sslContext) && Tls.equals(this.sslParameters, tlsConfig.sslParameters);
    }

    public SSLServerSocket createServerSocket() {
        try {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket();
            socket.setSSLParameters(this.sslParameters);
            return socket;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SSLSocket createSocket(String alpnProtocol) {
        try {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket();
            this.sslParameters.setApplicationProtocols(new String[]{alpnProtocol});
            socket.setSSLParameters(this.sslParameters);
            return socket;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public SSLParameters sslParameters() {
        return this.sslParameters;
    }

    public void reload(Tls tls) {
        for (TlsReloadableComponent reloadableComponent : this.reloadableComponents) {
            reloadableComponent.reload(tls);
        }
    }

    X509TrustManager originalTrustManager() {
        return this.originalTrustManager;
    }

    X509KeyManager originalKeyManager() {
        return this.originalKeyManager;
    }

    public boolean enabled() {
        return this.enabled;
    }

    private static int hashCode(SSLParameters first) {
        int result = Objects.hash(first.getAlgorithmConstraints(), first.getEnableRetransmissions(), first.getEndpointIdentificationAlgorithm(), first.getMaximumPacketSize(), first.getNeedClientAuth(), first.getUseCipherSuitesOrder(), first.getWantClientAuth(), first.getServerNames(), first.getSNIMatchers());
        result = 31 * result + Arrays.hashCode(first.getApplicationProtocols());
        result = 31 * result + Arrays.hashCode(first.getCipherSuites());
        result = 31 * result + Arrays.hashCode(first.getProtocols());
        return result;
    }

    private static boolean equals(SSLParameters first, SSLParameters second) {
        return first.getAlgorithmConstraints().equals(second.getAlgorithmConstraints()) && Arrays.equals(first.getApplicationProtocols(), second.getApplicationProtocols()) && Arrays.equals(first.getCipherSuites(), second.getCipherSuites()) && first.getEnableRetransmissions() == second.getEnableRetransmissions() && Objects.equals(first.getEndpointIdentificationAlgorithm(), second.getEndpointIdentificationAlgorithm()) && first.getMaximumPacketSize() == second.getMaximumPacketSize() && first.getNeedClientAuth() == second.getNeedClientAuth() && Arrays.equals(first.getProtocols(), second.getProtocols()) && first.getUseCipherSuitesOrder() == second.getUseCipherSuitesOrder() && first.getWantClientAuth() == second.getWantClientAuth() && first.getServerNames().equals(second.getServerNames()) && first.getSNIMatchers().equals(second.getSNIMatchers());
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Tls> {
        private static final String DEFAULT_PROTOCOL = "TLS";
        private static final int DEFAULT_SESSION_CACHE_SIZE = 1024;
        private String protocol = "TLS";
        private String provider;
        private Duration sessionTimeout = Duration.ofMinutes(30L);
        private int sessionCacheSize = 1024;
        private List<String> enabledCipherSuites;
        private List<String> enabledProtocols;
        private List<String> applicationProtocols;
        private SSLContext sslContext;
        private SecureRandom secureRandom;
        private String secureRandomAlgorithm;
        private String secureRandomProvider;
        private TlsClientAuth tlsClientAuth = TlsClientAuth.NONE;
        private String internalKeystoreType = KeyStore.getDefaultType();
        private String internalKeystoreProvider;
        private PrivateKey privateKey;
        private List<X509Certificate> privateKeyCertChain;
        private String kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        private String kmfProvider;
        private List<X509Certificate> trustCertificates;
        private String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        private String tmfProvider;
        private boolean trustAll = false;
        private SSLParameters sslParameters;
        private String endpointIdentificationAlgorithm = "HTTPS";
        private boolean enabled = true;
        private final List<TlsReloadableComponent> reloadableComponents = new ArrayList<TlsReloadableComponent>();
        private X509TrustManager originalTrustManager;
        private X509KeyManager originalKeyManager;

        private Builder() {
        }

        public Tls build() {
            if (this.sslParameters == null) {
                this.sslParameters = this.createSslParameters();
            }
            if (this.sslContext == null) {
                this.sslContext = this.createSslContext();
                return new TlsConfigImpl(this);
            }
            return new ExplicitContextTlsConfig(this);
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder sessionTimeout(Duration sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder sessionCacheSize(int sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return this;
        }

        public Builder enabledCipherSuites(List<String> enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public Builder enabledProtocols(List<String> enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder privateKeyCertChain(List<X509Certificate> privateKeyCertChain) {
            this.privateKeyCertChain = privateKeyCertChain;
            return this;
        }

        public Builder keyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
            this.kmfAlgorithm = keyManagerFactoryAlgorithm;
            return this;
        }

        public Builder trustCertificates(List<X509Certificate> trustCertificates) {
            this.trustCertificates = trustCertificates;
            return this;
        }

        public Builder secureRandomAlgorithm(String secureRandomAlgorithm) {
            this.secureRandomAlgorithm = secureRandomAlgorithm;
            return this;
        }

        public Builder secureRandomProvider(String secureRandomProvider) {
            this.secureRandomProvider = secureRandomProvider;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder tlsClientAuth(TlsClientAuth tlsClientAuth) {
            this.tlsClientAuth = tlsClientAuth;
            return this;
        }

        public Builder trustAll(boolean trustAll) {
            this.trustAll = trustAll;
            return this;
        }

        public Builder internalKeystoreType(String internalKeystoreType) {
            this.internalKeystoreType = internalKeystoreType;
            return this;
        }

        public Builder internalKeystoreProvider(String internalKeystoreProvider) {
            this.internalKeystoreProvider = internalKeystoreProvider;
            return this;
        }

        public Builder keyManagerFactoryProvider(String keyManagerFactoryProvider) {
            this.kmfProvider = keyManagerFactoryProvider;
            return this;
        }

        public Builder trustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
            this.tmfAlgorithm = trustManagerFactoryAlgorithm;
            return this;
        }

        public Builder trustManagerFactoryProvider(String trustManagerFactoryProvider) {
            this.tmfProvider = trustManagerFactoryProvider;
            return this;
        }

        public Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder endpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
            this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
            return this;
        }

        public Builder applicationProtocols(List<String> applicationProtocols) {
            this.applicationProtocols = applicationProtocols;
            return this;
        }

        public Builder config(Config config) {
            config.get("client-auth").asString().as(TlsClientAuth::valueOf).ifPresent(this::tlsClientAuth);
            config.get("private-key").map(KeyConfig::create).ifPresent(keyConfig -> {
                this.privateKey((PrivateKey)keyConfig.privateKey().get());
                this.privateKeyCertChain(keyConfig.certChain());
            });
            config.get("trust").map(KeyConfig::create).map(KeyConfig::certs).ifPresent(this::trustCertificates);
            config.get("protocols").asList(String.class).ifPresent(this::enabledProtocols);
            config.get("session-cache-size").asInt().ifPresent(this::sessionCacheSize);
            config.get("cipher-suite").asList(String.class).ifPresent(this::enabledCipherSuites);
            config.get("session-timeout-seconds").asInt().ifPresent(this::sessionTimeoutSeconds);
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        private SSLParameters createSslParameters() {
            SSLParameters sslParameters = new SSLParameters();
            if (this.applicationProtocols != null) {
                sslParameters.setApplicationProtocols(this.applicationProtocols.toArray(new String[0]));
            }
            if (this.enabledProtocols != null) {
                sslParameters.setProtocols(this.enabledProtocols.toArray(new String[0]));
            }
            if (this.enabledCipherSuites != null) {
                sslParameters.setCipherSuites(this.enabledCipherSuites.toArray(new String[0]));
            }
            switch (this.tlsClientAuth) {
                case REQUIRED: {
                    sslParameters.setNeedClientAuth(true);
                    sslParameters.setWantClientAuth(true);
                    break;
                }
                case OPTIONAL: {
                    sslParameters.setWantClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
            }
            if (this.endpointIdentificationAlgorithm != null) {
                if (Tls.ENDPOINT_IDENTIFICATION_NONE.equals(this.endpointIdentificationAlgorithm)) {
                    sslParameters.setEndpointIdentificationAlgorithm("");
                } else {
                    sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
                }
            }
            return sslParameters;
        }

        private SSLContext createSslContext() {
            try {
                return this.sslContext();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Failed to create SSL engine", e);
            }
        }

        private SSLContext sslContext() throws GeneralSecurityException, IOException {
            SecureRandom secureRandom = this.secureRandom();
            KeyManagerFactory kmf = this.privateKey == null ? null : this.buildKmf(secureRandom);
            Object tmf = this.trustAll ? this.buildTrustAllTmf() : (this.trustCertificates == null ? null : this.buildTmf());
            SSLContext sslContext = this.provider == null ? SSLContext.getInstance(this.protocol) : SSLContext.getInstance(this.protocol, this.provider);
            sslContext.init(kmf == null ? null : this.wrapX509KeyManagers(kmf.getKeyManagers()), tmf == null ? null : this.wrapX509TrustManagers(((TrustManagerFactory)tmf).getTrustManagers()), secureRandom);
            SSLSessionContext serverSessionContext = sslContext.getServerSessionContext();
            if (serverSessionContext != null) {
                serverSessionContext.setSessionCacheSize(this.sessionCacheSize);
                serverSessionContext.setSessionTimeout((int)this.sessionTimeout.toSeconds());
            }
            return sslContext;
        }

        private TrustManager[] wrapX509TrustManagers(TrustManager[] trustManagers) {
            TrustManager[] toReturn = new TrustManager[trustManagers.length];
            System.arraycopy(trustManagers, 0, toReturn, 0, toReturn.length);
            for (int i = 0; i < trustManagers.length; ++i) {
                X509TrustManager x509TrustManager;
                TrustManager trustManager = trustManagers[i];
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.originalTrustManager = x509TrustManager = (X509TrustManager)trustManager;
                ReloadableX509TrustManager wrappedTrustManager = new ReloadableX509TrustManager(x509TrustManager);
                this.reloadableComponents.add(wrappedTrustManager);
                toReturn[i] = wrappedTrustManager;
                return toReturn;
            }
            this.reloadableComponents.add(new ReloadableX509TrustManager.NotReloadableTrustManager());
            return toReturn;
        }

        private KeyManager[] wrapX509KeyManagers(KeyManager[] keyManagers) {
            KeyManager[] toReturn = new KeyManager[keyManagers.length];
            System.arraycopy(keyManagers, 0, toReturn, 0, toReturn.length);
            for (int i = 0; i < keyManagers.length; ++i) {
                X509KeyManager x509KeyManager;
                KeyManager keyManager = keyManagers[i];
                if (!(keyManager instanceof X509KeyManager)) continue;
                this.originalKeyManager = x509KeyManager = (X509KeyManager)keyManager;
                ReloadableX509KeyManager wrappedKeyManager = new ReloadableX509KeyManager(x509KeyManager);
                this.reloadableComponents.add(wrappedKeyManager);
                toReturn[i] = wrappedKeyManager;
                return toReturn;
            }
            this.reloadableComponents.add(new ReloadableX509KeyManager.NotReloadableKeyManager());
            return toReturn;
        }

        private void sessionTimeoutSeconds(int seconds) {
            this.sessionTimeout(Duration.ofSeconds(seconds));
        }

        private SecureRandom secureRandom() {
            block4: {
                if (this.secureRandom != null) {
                    return this.secureRandom;
                }
                try {
                    if (this.secureRandomAlgorithm == null) break block4;
                    if (this.secureRandomProvider == null) {
                        SecureRandom.getInstance(this.secureRandomAlgorithm);
                        break block4;
                    }
                    return SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    throw new IllegalArgumentException("Invalid configuration of secure random. Provider: " + this.secureRandomProvider + ", algorithm: " + this.secureRandomAlgorithm, e);
                }
            }
            return (SecureRandom)RANDOM.get();
        }

        private KeyManagerFactory buildKmf(SecureRandom secureRandom) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
            byte[] passwordBytes = new byte[64];
            secureRandom.nextBytes(passwordBytes);
            char[] password = Base64.getEncoder().encodeToString(passwordBytes).toCharArray();
            KeyStore ks = this.keystore();
            ks.setKeyEntry("key", this.privateKey, password, this.privateKeyCertChain.toArray(new Certificate[0]));
            KeyManagerFactory kmf = this.kmf();
            kmf.init(ks, password);
            return kmf;
        }

        private TrustManagerFactory buildTrustAllTmf() {
            return new TrustAllManagerFactory();
        }

        private TrustManagerFactory buildTmf() throws KeyStoreException {
            KeyStore ks = this.keystore();
            int i = 1;
            for (X509Certificate cert : this.trustCertificates) {
                ks.setCertificateEntry(String.valueOf(i), cert);
                ++i;
            }
            TrustManagerFactory tmf = this.tmf();
            tmf.init(ks);
            return tmf;
        }

        private KeyManagerFactory kmf() {
            try {
                return this.kmfProvider == null ? KeyManagerFactory.getInstance(this.kmfAlgorithm) : KeyManagerFactory.getInstance(this.kmfAlgorithm, this.kmfProvider);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new IllegalArgumentException("Invalid configuration of key manager factory. Provider: " + this.kmfProvider + ", algorithm: " + this.kmfAlgorithm, e);
            }
        }

        private TrustManagerFactory tmf() {
            try {
                return this.tmfProvider == null ? TrustManagerFactory.getInstance(this.tmfAlgorithm) : TrustManagerFactory.getInstance(this.tmfAlgorithm, this.tmfProvider);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new IllegalArgumentException("Invalid configuration of trust manager factory. Provider: " + this.tmfProvider + ", algorithm: " + this.tmfAlgorithm, e);
            }
        }

        private KeyStore keystore() {
            try {
                KeyStore ks = this.internalKeystoreProvider == null ? KeyStore.getInstance(this.internalKeystoreType) : KeyStore.getInstance(this.internalKeystoreType, this.internalKeystoreProvider);
                ks.load(null, null);
                return ks;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                throw new IllegalArgumentException("Invalid configuration of internal keystores. Provider: " + this.internalKeystoreProvider + ", type: " + this.internalKeystoreType, e);
            }
        }
    }

    static final class ExplicitContextTlsConfig
    extends Tls {
        private ExplicitContextTlsConfig(Builder builder) {
            super(builder);
        }
    }

    static final class TlsConfigImpl
    extends Tls {
        private final String protocol;
        private final String provider;
        private final Duration sessionTimeout;
        private final int sessionCacheSize;
        private final String secureRandomAlgorithm;
        private final String secureRandomProvider;
        private final String internalKeystoreType;
        private final String internalKeystoreProvider;
        private final PrivateKey privateKey;
        private final List<X509Certificate> privateKeyCertChain;
        private final String kmfAlgorithm;
        private final String kmfProvider;
        private final List<X509Certificate> trustCertificates;
        private final String tmfAlgorithm;
        private final String tmfProvider;
        private final boolean trustAll;

        TlsConfigImpl(Builder builder) {
            super(builder);
            this.protocol = builder.protocol;
            this.provider = builder.provider;
            this.sessionTimeout = builder.sessionTimeout;
            this.sessionCacheSize = builder.sessionCacheSize;
            this.secureRandomAlgorithm = builder.secureRandomAlgorithm;
            this.secureRandomProvider = builder.secureRandomProvider;
            this.internalKeystoreType = builder.internalKeystoreType;
            this.internalKeystoreProvider = builder.internalKeystoreProvider;
            this.privateKey = builder.privateKey;
            this.privateKeyCertChain = builder.privateKeyCertChain;
            this.kmfAlgorithm = builder.kmfAlgorithm;
            this.kmfProvider = builder.kmfProvider;
            this.trustCertificates = builder.trustCertificates;
            this.tmfAlgorithm = builder.tmfAlgorithm;
            this.tmfProvider = builder.tmfProvider;
            this.trustAll = builder.trustAll;
        }

        @Override
        public int hashCode() {
            return 31 * Tls.hashCode(super.sslParameters()) + Objects.hash(this.protocol, this.provider, this.sessionTimeout, this.sessionCacheSize, this.secureRandomAlgorithm, this.secureRandomProvider, this.internalKeystoreType, this.internalKeystoreProvider, this.privateKey, this.privateKeyCertChain, this.kmfAlgorithm, this.kmfProvider, this.trustCertificates, this.tmfAlgorithm, this.tmfProvider, this.trustAll);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tls)) {
                return false;
            }
            if (super.equals(o)) {
                return true;
            }
            if (!(o instanceof TlsConfigImpl)) {
                return false;
            }
            TlsConfigImpl tlsConfig = (TlsConfigImpl)o;
            return this.sessionCacheSize == tlsConfig.sessionCacheSize && this.trustAll == tlsConfig.trustAll && Objects.equals(this.protocol, tlsConfig.protocol) && Objects.equals(this.provider, tlsConfig.provider) && Objects.equals(this.sessionTimeout, tlsConfig.sessionTimeout) && Objects.equals(this.secureRandomAlgorithm, tlsConfig.secureRandomAlgorithm) && Objects.equals(this.secureRandomProvider, tlsConfig.secureRandomProvider) && Objects.equals(this.internalKeystoreType, tlsConfig.internalKeystoreType) && Objects.equals(this.internalKeystoreProvider, tlsConfig.internalKeystoreProvider) && Objects.equals(this.privateKey, tlsConfig.privateKey) && Objects.equals(this.privateKeyCertChain, tlsConfig.privateKeyCertChain) && Objects.equals(this.kmfAlgorithm, tlsConfig.kmfAlgorithm) && Objects.equals(this.kmfProvider, tlsConfig.kmfProvider) && Objects.equals(this.trustCertificates, tlsConfig.trustCertificates) && Objects.equals(this.tmfAlgorithm, tlsConfig.tmfAlgorithm) && Objects.equals(this.tmfProvider, tlsConfig.tmfProvider);
        }
    }
}

