/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.nima.faulttolerance.AsyncImpl;
import io.helidon.nima.faulttolerance.FaultTolerance;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface Async {
    public <T> CompletableFuture<T> invoke(Supplier<T> var1);

    public static Async create() {
        return AsyncImpl.DefaultAsyncInstance.instance();
    }

    public static <T> CompletableFuture<T> invokeStatic(Supplier<T> supplier) {
        return Async.create().invoke(supplier);
    }

    public static <T> CompletableFuture<T> invokeStatic(Supplier<T> supplier, CompletableFuture<Async> onStart) {
        return new Builder().onStart(onStart).build().invoke(supplier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Async> {
        private LazyValue<? extends ExecutorService> executor = FaultTolerance.executor();
        private CompletableFuture<Async> onStart;

        private Builder() {
        }

        public Async build() {
            return new AsyncImpl(this);
        }

        public Builder executor(Supplier<? extends ExecutorService> executor) {
            this.executor = LazyValue.create(Objects.requireNonNull(executor));
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = LazyValue.create((Object)Objects.requireNonNull(executor));
            return this;
        }

        public Builder onStart(CompletableFuture<Async> onStart) {
            this.onStart = onStart;
            return this;
        }

        LazyValue<? extends ExecutorService> executor() {
            return this.executor;
        }

        CompletableFuture<Async> onStart() {
            return this.onStart;
        }
    }
}

