/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.nima.faulttolerance.Async;
import io.helidon.nima.faulttolerance.SupplierHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class AsyncImpl
implements Async {
    private static final System.Logger LOGGER = System.getLogger(AsyncImpl.class.getName());
    private final LazyValue<? extends ExecutorService> executor;
    private final CompletableFuture<Async> onStart;

    AsyncImpl() {
        this(Async.builder());
    }

    AsyncImpl(Async.Builder builder) {
        this.executor = builder.executor();
        this.onStart = builder.onStart();
    }

    @Override
    public <T> CompletableFuture<T> invoke(Supplier<T> supplier) {
        final AtomicReference ourFuture = new AtomicReference();
        CompletableFuture result = new CompletableFuture<T>(this){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                Future toCancel = (Future)ourFuture.get();
                if (toCancel == null) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to cancel future, it is not yet available.");
                    return false;
                }
                return toCancel.cancel(mayInterruptIfRunning);
            }
        };
        Future<?> future = ((ExecutorService)this.executor.get()).submit(() -> {
            Thread thread = Thread.currentThread();
            thread.setName(thread.getName() + ": async");
            if (this.onStart != null) {
                this.onStart.complete(this);
            }
            try {
                Object t = supplier.get();
                result.complete(t);
            }
            catch (Throwable t) {
                Throwable throwable = SupplierHelper.unwrapThrowable(t);
                result.completeExceptionally(throwable);
            }
        });
        ourFuture.set(future);
        return result;
    }

    static final class DefaultAsyncInstance {
        private static final Async INSTANCE = new AsyncImpl();

        DefaultAsyncInstance() {
        }

        static Async instance() {
            return INSTANCE;
        }
    }
}

