/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.nima.faulttolerance.BulkheadImpl;
import io.helidon.nima.faulttolerance.FtHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public interface Bulkhead
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public Stats stats();

    public boolean cancelSupplier(Supplier<?> var1);

    public static class Builder
    implements io.helidon.common.Builder<Builder, Bulkhead> {
        private static final int DEFAULT_LIMIT = 10;
        private static final int DEFAULT_QUEUE_LENGTH = 10;
        private int limit = 10;
        private int queueLength = 10;
        private String name = "Bulkhead-" + System.identityHashCode(this);
        private List<QueueListener> listeners = new ArrayList<QueueListener>();

        private Builder() {
        }

        public Bulkhead build() {
            return new BulkheadImpl(this);
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder queueLength(int queueLength) {
            this.queueLength = queueLength;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addQueueListener(QueueListener listener) {
            this.listeners.add(listener);
            return this;
        }

        int limit() {
            return this.limit;
        }

        int queueLength() {
            return this.queueLength;
        }

        String name() {
            return this.name;
        }

        List<QueueListener> queueListeners() {
            return this.listeners;
        }
    }

    public static interface QueueListener {
        default public <T> void enqueueing(Supplier<? extends T> supplier) {
        }

        default public <T> void dequeued(Supplier<? extends T> supplier) {
        }
    }

    public static interface Stats {
        public long concurrentExecutions();

        public long callsAccepted();

        public long callsRejected();

        public long waitingQueueSize();
    }
}

