/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.nima.faulttolerance.CircuitBreakerImpl;
import io.helidon.nima.faulttolerance.FaultTolerance;
import io.helidon.nima.faulttolerance.FtHandler;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public interface CircuitBreaker
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public State state();

    public void state(State var1);

    public static class Builder
    implements io.helidon.common.Builder<Builder, CircuitBreaker> {
        private final Set<Class<? extends Throwable>> skipOn = new HashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> applyOn = new HashSet<Class<? extends Throwable>>();
        private Duration delay = Duration.ofSeconds(5L);
        private int ratio = 60;
        private int successThreshold = 1;
        private int volume = 10;
        private LazyValue<? extends ExecutorService> executor = FaultTolerance.executor();
        private String name = "CircuitBreaker-" + System.identityHashCode(this);

        private Builder() {
        }

        public CircuitBreaker build() {
            return new CircuitBreakerImpl(this);
        }

        public Builder delay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public Builder errorRatio(int ratio) {
            this.ratio = ratio;
            return this;
        }

        public Builder successThreshold(int successThreshold) {
            this.successThreshold = successThreshold;
            return this;
        }

        public Builder volume(int volume) {
            this.volume = volume;
            return this;
        }

        @SafeVarargs
        public final Builder applyOn(Class<? extends Throwable> ... classes) {
            this.applyOn.clear();
            Arrays.stream(classes).forEach(this::addApplyOn);
            return this;
        }

        public Builder addApplyOn(Class<? extends Throwable> clazz) {
            this.applyOn.add(clazz);
            return this;
        }

        @SafeVarargs
        public final Builder skipOn(Class<? extends Throwable> ... classes) {
            this.skipOn.clear();
            Arrays.stream(classes).forEach(this::addSkipOn);
            return this;
        }

        public Builder addSkipOn(Class<? extends Throwable> clazz) {
            this.skipOn.add(clazz);
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = LazyValue.create((Object)executor);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        LazyValue<? extends ExecutorService> executor() {
            return this.executor;
        }

        Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        Duration delay() {
            return this.delay;
        }

        int errorRatio() {
            return this.ratio;
        }

        int successThreshold() {
            return this.successThreshold;
        }

        int volume() {
            return this.volume;
        }

        String name() {
            return this.name;
        }
    }

    public static enum State {
        CLOSED,
        HALF_OPEN,
        OPEN;

    }
}

