/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.nima.faulttolerance.CircuitBreaker;
import io.helidon.nima.faulttolerance.CircuitBreakerOpenException;
import io.helidon.nima.faulttolerance.ErrorChecker;
import io.helidon.nima.faulttolerance.FaultTolerance;
import io.helidon.nima.faulttolerance.ResultWindow;
import io.helidon.nima.faulttolerance.SupplierHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class CircuitBreakerImpl
implements CircuitBreaker {
    private final LazyValue<? extends ExecutorService> executor;
    private final long delayMillis;
    private final int successThreshold;
    private final AtomicReference<CircuitBreaker.State> state = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    private final ResultWindow results;
    private final AtomicInteger successCounter = new AtomicInteger();
    private final AtomicBoolean halfOpenInProgress = new AtomicBoolean();
    private final AtomicReference<Future<Boolean>> schedule = new AtomicReference();
    private final ErrorChecker errorChecker;
    private final String name;

    CircuitBreakerImpl(CircuitBreaker.Builder builder) {
        this.delayMillis = builder.delay().toMillis();
        this.successThreshold = builder.successThreshold();
        this.results = new ResultWindow(builder.volume(), builder.errorRatio());
        this.executor = builder.executor();
        this.errorChecker = ErrorChecker.create(builder.skipOn(), builder.applyOn());
        this.name = builder.name();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> T invoke(Supplier<? extends T> supplier) {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case CircuitBreaker.State.CLOSED -> this.executeTask(supplier);
            case CircuitBreaker.State.HALF_OPEN -> this.halfOpenTask(supplier);
            case CircuitBreaker.State.OPEN -> throw new CircuitBreakerOpenException("CircuitBreaker is open");
        };
    }

    @Override
    public CircuitBreaker.State state() {
        return this.state.get();
    }

    @Override
    public void state(CircuitBreaker.State newState) {
        if (newState == CircuitBreaker.State.CLOSED) {
            if (this.state.get() == CircuitBreaker.State.CLOSED) {
                this.resetCounters();
                return;
            }
            Future future = this.schedule.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
            this.resetCounters();
            this.state.set(CircuitBreaker.State.CLOSED);
        } else if (newState == CircuitBreaker.State.OPEN) {
            this.state.set(CircuitBreaker.State.OPEN);
            Future future = this.schedule.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
            this.resetCounters();
        } else {
            this.resetCounters();
        }
    }

    private <U> U executeTask(Supplier<? extends U> supplier) {
        try {
            U result = supplier.get();
            this.results.update(ResultWindow.Result.SUCCESS);
            U u = result;
            return u;
        }
        catch (Throwable t) {
            Throwable throwable = SupplierHelper.unwrapThrowable(t);
            if (this.errorChecker.shouldSkip(throwable)) {
                this.results.update(ResultWindow.Result.SUCCESS);
            } else {
                this.results.update(ResultWindow.Result.FAILURE);
            }
            throw SupplierHelper.toRuntimeException(throwable);
        }
        finally {
            if (this.results.shouldOpen() && this.state.compareAndSet(CircuitBreaker.State.CLOSED, CircuitBreaker.State.OPEN)) {
                this.results.reset();
                this.scheduleHalf();
            }
        }
    }

    private <U> U halfOpenTask(Supplier<? extends U> supplier) {
        if (this.halfOpenInProgress.compareAndSet(false, true)) {
            try {
                U result = supplier.get();
                int successes = this.successCounter.incrementAndGet();
                if (successes >= this.successThreshold) {
                    this.successCounter.set(0);
                    this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED);
                }
                U u = result;
                return u;
            }
            catch (Throwable t) {
                Throwable throwable = SupplierHelper.unwrapThrowable(t);
                if (this.errorChecker.shouldSkip(throwable)) {
                    int successes = this.successCounter.incrementAndGet();
                    if (successes >= this.successThreshold) {
                        this.successCounter.set(0);
                        this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED);
                    }
                } else {
                    this.successCounter.set(0);
                    this.state.set(CircuitBreaker.State.OPEN);
                    this.scheduleHalf();
                }
                throw SupplierHelper.toRuntimeException(throwable);
            }
            finally {
                this.halfOpenInProgress.set(false);
            }
        }
        throw new CircuitBreakerOpenException("CircuitBreaker is half open, parallel execution in progress");
    }

    private void scheduleHalf() {
        this.schedule.set(((ExecutorService)this.executor.get()).submit(FaultTolerance.toDelayedCallable(() -> {
            this.state.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN);
            this.schedule.set(null);
            return true;
        }, this.delayMillis)));
    }

    Future<Boolean> schedule() {
        return this.schedule.get();
    }

    private void resetCounters() {
        this.results.reset();
        this.successCounter.set(0);
    }
}

