/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.nima.faulttolerance.FallbackImpl;
import io.helidon.nima.faulttolerance.FtHandlerTyped;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public interface Fallback<T>
extends FtHandlerTyped<T> {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Fallback<T> create(Function<Throwable, ? extends T> fallback) {
        Builder<? extends T> builder = Fallback.builder();
        return builder.fallback(fallback).build();
    }

    public static class Builder<T>
    implements io.helidon.common.Builder<Builder<T>, Fallback<T>> {
        private final Set<Class<? extends Throwable>> applyOn = new HashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new HashSet<Class<? extends Throwable>>();
        private Function<Throwable, ? extends T> fallback;

        private Builder() {
        }

        public Fallback<T> build() {
            return new FallbackImpl(this);
        }

        public Builder<T> fallback(Function<Throwable, ? extends T> fallback) {
            this.fallback = fallback;
            return this;
        }

        @SafeVarargs
        public final Builder<T> applyOn(Class<? extends Throwable> ... classes) {
            this.applyOn.clear();
            Arrays.stream(classes).forEach(this::addApplyOn);
            return this;
        }

        public Builder<T> addApplyOn(Class<? extends Throwable> clazz) {
            this.applyOn.add(clazz);
            return this;
        }

        @SafeVarargs
        public final Builder<T> skipOn(Class<? extends Throwable> ... classes) {
            this.skipOn.clear();
            Arrays.stream(classes).forEach(this::addSkipOn);
            return this;
        }

        public Builder<T> addSkipOn(Class<? extends Throwable> clazz) {
            this.skipOn.add(clazz);
            return this;
        }

        Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        Function<Throwable, ? extends T> fallback() {
            return this.fallback;
        }
    }
}

