/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.nima.faulttolerance.ErrorChecker;
import io.helidon.nima.faulttolerance.Fallback;
import io.helidon.nima.faulttolerance.SupplierHelper;
import java.util.function.Function;
import java.util.function.Supplier;

class FallbackImpl<T>
implements Fallback<T> {
    private final Function<Throwable, ? extends T> fallback;
    private final ErrorChecker errorChecker;

    FallbackImpl(Fallback.Builder<T> builder) {
        this.fallback = builder.fallback();
        this.errorChecker = ErrorChecker.create(builder.skipOn(), builder.applyOn());
    }

    @Override
    public T invoke(Supplier<? extends T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            Throwable throwable = SupplierHelper.unwrapThrowable(t);
            if (this.errorChecker.shouldSkip(throwable)) {
                throw SupplierHelper.toRuntimeException(throwable);
            }
            try {
                return this.fallback.apply(throwable);
            }
            catch (Throwable t2) {
                Throwable throwable2 = SupplierHelper.unwrapThrowable(t2);
                if (throwable2 != throwable) {
                    throwable2.addSuppressed(throwable);
                }
                throw SupplierHelper.toRuntimeException(throwable2);
            }
        }
    }
}

