/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.nima.faulttolerance.Bulkhead;
import io.helidon.nima.faulttolerance.CircuitBreaker;
import io.helidon.nima.faulttolerance.Fallback;
import io.helidon.nima.faulttolerance.FtHandler;
import io.helidon.nima.faulttolerance.FtHandlerTyped;
import io.helidon.nima.faulttolerance.Retry;
import io.helidon.nima.faulttolerance.Timeout;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class FaultTolerance {
    private static final System.Logger LOGGER = System.getLogger(FaultTolerance.class.getName());
    private static final AtomicReference<LazyValue<ExecutorService>> EXECUTOR = new AtomicReference();
    private static final AtomicReference<Config> CONFIG = new AtomicReference<Config>(Config.empty());

    private FaultTolerance() {
    }

    public static void config(Config config) {
        CONFIG.set(config);
    }

    public static void executor(Supplier<? extends ExecutorService> executor) {
        EXECUTOR.set((LazyValue<ExecutorService>)LazyValue.create(executor::get));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> TypedBuilder<T> typedBuilder() {
        return new TypedBuilder();
    }

    public static Runnable toDelayedRunnable(Runnable runnable, long millis) {
        return () -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Delayed runnable was unexpectedly interrupted");
            }
            runnable.run();
        };
    }

    public static <T> Callable<T> toDelayedCallable(Callable<T> callable, long millis) {
        return () -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Delayed callable was unexpectedly interrupted");
            }
            return callable.call();
        };
    }

    static LazyValue<? extends ExecutorService> executor() {
        return EXECUTOR.get();
    }

    static Config config() {
        return CONFIG.get();
    }

    static {
        EXECUTOR.set((LazyValue<ExecutorService>)LazyValue.create(() -> Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("helidon-ft-", 0L).factory())));
    }

    public static class Builder
    extends BaseBuilder<Builder>
    implements io.helidon.common.Builder<Builder, FtHandler> {
        private final List<FtHandler> fts = new LinkedList<FtHandler>();

        private Builder() {
        }

        public FtHandler build() {
            return new FtHandlerImpl(this.fts);
        }

        public <U> TypedBuilder<U> addFallback(Fallback<U> fallback) {
            return new TypedBuilder().builder(this).addFallback(fallback);
        }

        @Override
        public Builder add(FtHandler ft) {
            this.fts.add(ft);
            return this;
        }

        private static class FtHandlerImpl
        implements FtHandler {
            private final List<FtHandler> validFts;
            private final String name = "FtHandler-" + System.identityHashCode(this);

            private FtHandlerImpl(List<FtHandler> validFts) {
                this.validFts = new LinkedList<FtHandler>(validFts);
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public <T> T invoke(Supplier<? extends T> supplier) {
                Supplier<Object> next = supplier;
                for (FtHandler validFt : this.validFts) {
                    Supplier finalNext = next;
                    next = () -> validFt.invoke(finalNext);
                }
                return next.get();
            }
        }
    }

    public static class TypedBuilder<T>
    extends BaseBuilder<TypedBuilder<T>>
    implements io.helidon.common.Builder<TypedBuilder<T>, FtHandlerTyped<T>> {
        private final List<FtHandlerTyped<T>> fts = new LinkedList<FtHandlerTyped<T>>();

        private TypedBuilder() {
        }

        public FtHandlerTyped<T> build() {
            return new FtHandlerTypedImpl<T>(this.fts);
        }

        @Override
        public TypedBuilder<T> add(FtHandler ft) {
            this.fts.add(new TypedWrapper(this, ft));
            return this;
        }

        public TypedBuilder<T> addFallback(Fallback<T> fallback) {
            this.fts.add(fallback);
            return this;
        }

        private TypedBuilder<T> builder(Builder builder) {
            builder.fts.forEach(it -> this.fts.add(new TypedWrapper(this, (FtHandler)it)));
            return this;
        }

        private static class FtHandlerTypedImpl<T>
        implements FtHandlerTyped<T> {
            private final List<FtHandlerTyped<T>> validFts;

            private FtHandlerTypedImpl(List<FtHandlerTyped<T>> validFts) {
                this.validFts = new LinkedList<FtHandlerTyped<T>>(validFts);
            }

            @Override
            public T invoke(Supplier<? extends T> supplier) {
                Supplier<Object> next = supplier;
                for (FtHandlerTyped validFt : this.validFts) {
                    Supplier finalNext = next;
                    next = () -> validFt.invoke(finalNext);
                }
                return next.get();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int i = this.validFts.size() - 1; i >= 0; --i) {
                    sb.append(this.validFts.get(i).toString());
                    sb.append("\n");
                }
                return sb.toString();
            }
        }

        private class TypedWrapper
        implements FtHandlerTyped<T> {
            private final FtHandler handler;

            private TypedWrapper(TypedBuilder typedBuilder, FtHandler handler) {
                this.handler = handler;
            }

            @Override
            public T invoke(Supplier<? extends T> supplier) {
                return this.handler.invoke(supplier);
            }

            public String toString() {
                return this.handler.getClass().getSimpleName();
            }
        }
    }

    static abstract class BaseBuilder<B extends BaseBuilder<B>> {
        BaseBuilder() {
        }

        public B addBulkhead(Bulkhead bulkhead) {
            this.add(bulkhead);
            return this.me();
        }

        public B addBreaker(CircuitBreaker breaker) {
            this.add(breaker);
            return this.me();
        }

        public B addTimeout(Timeout timeout) {
            this.add(timeout);
            return this.me();
        }

        public B addRetry(Retry retry) {
            this.add(retry);
            return this.me();
        }

        public abstract B add(FtHandler var1);

        private B me() {
            return (B)this;
        }
    }
}

