/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.nima.faulttolerance.SupplierException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SupplierHelper {
    private SupplierHelper() {
    }

    public static <T> Supplier<T> toSyncSupplier(Supplier<? extends CompletionStage<T>> supplier, long timeout, TimeUnit unit) {
        return () -> {
            try {
                CompletionStage result = (CompletionStage)supplier.get();
                return result.toCompletableFuture().get(timeout, unit);
            }
            catch (Throwable t) {
                Throwable throwable = SupplierHelper.unwrapThrowable(t);
                throw SupplierHelper.toRuntimeException(throwable);
            }
        };
    }

    public static RuntimeException toRuntimeException(Throwable t) {
        RuntimeException runtimeException;
        if (t instanceof RuntimeException) {
            RuntimeException rt = (RuntimeException)t;
            runtimeException = rt;
        } else {
            runtimeException = new SupplierException(t);
        }
        return runtimeException;
    }

    public static Throwable unwrapThrowable(Throwable t) {
        if (t instanceof SupplierException || t instanceof ExecutionException) {
            return t.getCause();
        }
        return t;
    }
}

