/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.nima.faulttolerance.FaultTolerance;
import io.helidon.nima.faulttolerance.FtHandler;
import io.helidon.nima.faulttolerance.TimeoutImpl;
import java.time.Duration;
import java.util.concurrent.ExecutorService;

public interface Timeout
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public static Timeout create(Duration timeout) {
        return Timeout.builder().timeout(timeout).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Timeout> {
        private Duration timeout = Duration.ofSeconds(10L);
        private LazyValue<? extends ExecutorService> executor = FaultTolerance.executor();
        private boolean currentThread = false;
        private String name = "Timeout-" + System.identityHashCode(this);

        private Builder() {
        }

        public Timeout build() {
            return new TimeoutImpl(this);
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder currentThread(boolean currentThread) {
            this.currentThread = currentThread;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = LazyValue.create((Object)executor);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        Duration timeout() {
            return this.timeout;
        }

        LazyValue<? extends ExecutorService> executor() {
            return this.executor;
        }

        boolean currentThread() {
            return this.currentThread;
        }

        String name() {
            return this.name;
        }
    }
}

