/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.nima.faulttolerance.FaultTolerance;
import io.helidon.nima.faulttolerance.SupplierHelper;
import io.helidon.nima.faulttolerance.Timeout;
import io.helidon.nima.faulttolerance.TimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class TimeoutImpl
implements Timeout {
    private static final System.Logger LOGGER = System.getLogger(TimeoutImpl.class.getName());
    private final long timeoutMillis;
    private final LazyValue<? extends ExecutorService> executor;
    private final boolean currentThread;
    private final String name;

    TimeoutImpl(Timeout.Builder builder) {
        this.timeoutMillis = builder.timeout().toMillis();
        this.executor = builder.executor();
        this.currentThread = builder.currentThread();
        this.name = builder.name();
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(Supplier<? extends T> supplier) {
        if (!this.currentThread) {
            try {
                return CompletableFuture.supplyAsync(supplier, (Executor)this.executor.get()).orTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).get();
            }
            catch (Throwable t) {
                throw TimeoutImpl.mapThrowable(t, null);
            }
        }
        Thread thisThread = Thread.currentThread();
        ReentrantLock interruptLock = new ReentrantLock();
        AtomicBoolean callReturned = new AtomicBoolean(false);
        AtomicBoolean interrupted = new AtomicBoolean(false);
        ((ExecutorService)this.executor.get()).submit(FaultTolerance.toDelayedRunnable(() -> {
            interruptLock.lock();
            try {
                if (callReturned.compareAndSet(false, true)) {
                    thisThread.interrupt();
                    interrupted.set(true);
                }
            }
            finally {
                interruptLock.unlock();
            }
        }, this.timeoutMillis));
        try {
            T result = supplier.get();
            if (interrupted.get()) {
                throw new TimeoutException("Supplier execution interrupted", null);
            }
            T t = result;
            return t;
        }
        catch (Throwable t) {
            throw TimeoutImpl.mapThrowable(t, interrupted);
        }
        finally {
            interruptLock.lock();
            try {
                callReturned.set(true);
                if (Thread.interrupted()) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Current thread interrupted, clearing status");
                }
            }
            finally {
                interruptLock.unlock();
            }
        }
    }

    private static RuntimeException mapThrowable(Throwable t, AtomicBoolean interrupted) {
        Throwable throwable = SupplierHelper.unwrapThrowable(t);
        if (throwable instanceof InterruptedException) {
            return new TimeoutException("Call interrupted", throwable);
        }
        if (throwable instanceof java.util.concurrent.TimeoutException) {
            return new TimeoutException("Timeout reached", throwable.getCause());
        }
        if (interrupted != null && interrupted.get()) {
            return new TimeoutException("Supplier execution interrupted", t);
        }
        return SupplierHelper.toRuntimeException(throwable);
    }
}

