/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.encoding;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.http.Headers;
import io.helidon.nima.http.encoding.ContentDecoder;
import io.helidon.nima.http.encoding.ContentEncoder;
import io.helidon.nima.http.encoding.ContentEncodingSupportImpl;
import io.helidon.nima.http.encoding.spi.ContentEncodingProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;

public interface ContentEncodingContext {
    public static ContentEncodingContext create() {
        return ContentEncodingContext.builder().build();
    }

    public static ContentEncodingContext create(Config config) {
        return ContentEncodingContext.builder().config(config).build();
    }

    public boolean contentEncodingEnabled();

    public boolean contentDecodingEnabled();

    public boolean contentEncodingSupported(String var1);

    public boolean contentDecodingSupported(String var1);

    public ContentEncoder encoder(String var1) throws NoSuchElementException;

    public ContentDecoder decoder(String var1) throws NoSuchElementException;

    public ContentEncoder encoder(Headers var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, ContentEncodingContext> {
        private static final String IDENTITY_ENCODING = "identity";
        private final HelidonServiceLoader.Builder<ContentEncodingProvider> encodingProviders = HelidonServiceLoader.builder(ServiceLoader.load(ContentEncodingProvider.class));

        public Builder config(Config config) {
            config.get("discover-services").asBoolean().ifPresent(this::discoverServices);
            return this;
        }

        public Builder discoverServices(boolean discoverServices) {
            this.encodingProviders.useSystemServiceLoader(discoverServices);
            return this;
        }

        public Builder addEncodingProvider(ContentEncodingProvider encodingProvider) {
            this.encodingProviders.addService((Object)encodingProvider);
            return this;
        }

        public ContentEncodingContext build() {
            List providers = this.encodingProviders.build().asList();
            HashMap<String, ContentEncoder> encoders = new HashMap<String, ContentEncoder>();
            HashMap<String, ContentDecoder> decoders = new HashMap<String, ContentDecoder>();
            ContentEncoder firstEncoder = null;
            for (ContentEncodingProvider provider : providers) {
                Set<String> ids = provider.ids();
                if (provider.supportsEncoding()) {
                    for (String id : ids) {
                        ContentEncoder encoder = provider.encoder();
                        if (firstEncoder == null) {
                            firstEncoder = encoder;
                        }
                        encoders.putIfAbsent(id, encoder);
                    }
                }
                if (!provider.supportsDecoding()) continue;
                for (String id : ids) {
                    decoders.putIfAbsent(id, provider.decoder());
                }
            }
            encoders.put(IDENTITY_ENCODING, ContentEncoder.NO_OP);
            decoders.put(IDENTITY_ENCODING, ContentDecoder.NO_OP);
            return new ContentEncodingSupportImpl(Map.copyOf(encoders), Map.copyOf(decoders), firstEncoder);
        }
    }
}

