/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.Headers;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.WritableHeaders;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.nima.http.media.EntityReader;
import io.helidon.nima.http.media.EntityWriter;
import io.helidon.nima.http.media.jsonp.JsonpReader;
import io.helidon.nima.http.media.jsonp.JsonpWriter;
import io.helidon.nima.http.media.spi.MediaSupportProvider;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriterFactory;
import java.util.List;
import java.util.Map;

public class JsonpMediaSupportProvider
implements MediaSupportProvider {
    public static final GenericType<JsonObject> JSON_OBJECT_TYPE = GenericType.create(JsonObject.class);
    public static final GenericType<JsonArray> JSON_ARRAY_TYPE = GenericType.create(JsonArray.class);
    private static final JsonReaderFactory READER_FACTORY = Json.createReaderFactory(Map.of());
    private static final JsonWriterFactory WRITER_FACTORY = Json.createWriterFactory(Map.of());
    private final JsonpReader reader = new JsonpReader(READER_FACTORY);
    private final JsonpWriter writer = new JsonpWriter(WRITER_FACTORY);

    public static <T extends JsonStructure> EntityWriter<T> serverResponseWriter() {
        return new JsonpWriter(WRITER_FACTORY);
    }

    public static <T extends JsonStructure> EntityReader<T> serverRequestReader() {
        return new JsonpReader(READER_FACTORY);
    }

    public <T> MediaSupportProvider.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupportProvider.ReaderResponse(MediaSupportProvider.SupportLevel.SUPPORTED, this::reader);
        }
        return MediaSupportProvider.ReaderResponse.unsupported();
    }

    public <T> MediaSupportProvider.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupportProvider.WriterResponse(MediaSupportProvider.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupportProvider.WriterResponse.unsupported();
    }

    public <T> MediaSupportProvider.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (this.isSupportedType(type)) {
            List acceptedTypes = requestHeaders.acceptedTypes();
            if (acceptedTypes.isEmpty()) {
                return new MediaSupportProvider.ReaderResponse(MediaSupportProvider.SupportLevel.SUPPORTED, this::reader);
            }
            for (HttpMediaType acceptedType : acceptedTypes) {
                if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
                return new MediaSupportProvider.ReaderResponse(MediaSupportProvider.SupportLevel.SUPPORTED, this::reader);
            }
        }
        return MediaSupportProvider.ReaderResponse.unsupported();
    }

    public <T> MediaSupportProvider.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupportProvider.WriterResponse(MediaSupportProvider.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupportProvider.WriterResponse.unsupported();
    }

    boolean isSupportedType(GenericType<?> type) {
        return JsonStructure.class.isAssignableFrom(type.rawType());
    }

    <T> EntityReader<T> reader() {
        return this.reader;
    }

    <T> EntityWriter<T> writer() {
        return this.writer;
    }
}

