/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.Headers;
import io.helidon.nima.http.media.EntityReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

class JsonpReader<T extends JsonStructure>
implements EntityReader<T> {
    private final JsonReaderFactory readerFactory;

    JsonpReader(JsonReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
    }

    public T read(GenericType<T> type, InputStream stream, Headers headers) {
        return this.read(type, stream);
    }

    public T read(GenericType<T> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
        return this.read(type, stream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T read(GenericType<T> type, InputStream in) {
        try (InputStream inputStream = in;){
            JsonStructure jsonStructure = (JsonStructure)type.cast((Object)this.readerFactory.createReader(in).read());
            return (T)jsonStructure;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

