/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.WritableHeaders;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.nima.http.media.EntityWriter;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Optional;

class JsonpWriter<T extends JsonStructure>
implements EntityWriter<T> {
    private final JsonWriterFactory writerFactory;

    JsonpWriter(JsonWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        responseHeaders.setIfAbsent(Http.HeaderValues.CONTENT_TYPE_JSON);
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            Optional charset = acceptedType.charset();
            if (charset.isPresent()) {
                Charset characterSet = Charset.forName((String)charset.get());
                this.write(type, object, new OutputStreamWriter(outputStream, characterSet));
            } else {
                this.write(type, object, outputStream);
            }
            return;
        }
        this.write(type, object, outputStream);
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, WritableHeaders<?> headers) {
        headers.setIfAbsent(Http.HeaderValues.CONTENT_TYPE_JSON);
        this.write(type, object, outputStream);
    }

    private void write(GenericType<T> type, T object, Writer out) {
        JsonWriter writer = this.writerFactory.createWriter(out);
        writer.write(object);
    }

    private void write(GenericType<T> type, T object, OutputStream out) {
        try (OutputStream outputStream = out;){
            this.writerFactory.createWriter(out).write(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

