/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media;

import io.helidon.common.GenericType;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.http.Headers;
import io.helidon.common.http.WritableHeaders;
import io.helidon.nima.http.media.EntityReader;
import io.helidon.nima.http.media.EntityWriter;
import io.helidon.nima.http.media.FormParamsSupportProvider;
import io.helidon.nima.http.media.MediaContext;
import io.helidon.nima.http.media.PathSupportProvider;
import io.helidon.nima.http.media.StringSupportProvider;
import io.helidon.nima.http.media.spi.MediaSupportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class MediaContextImpl
implements MediaContext {
    private static final System.Logger LOGGER = System.getLogger(MediaContextImpl.class.getName());
    private static final ConcurrentHashMap<GenericType<?>, AtomicBoolean> LOGGED_READERS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<GenericType<?>, AtomicBoolean> LOGGED_WRITERS = new ConcurrentHashMap();
    private final List<MediaSupportProvider> providers = HelidonServiceLoader.builder(ServiceLoader.load(MediaSupportProvider.class)).addService((Object)new StringSupportProvider()).addService((Object)new FormParamsSupportProvider()).addService((Object)new PathSupportProvider()).build().asList();

    MediaContextImpl() {
        this.providers.forEach(it -> it.init(this));
    }

    @Override
    public <T> EntityReader<T> reader(GenericType<T> type, Headers headers) {
        MediaSupportProvider.ReaderResponse<T> compatible = null;
        for (MediaSupportProvider provider : this.providers) {
            MediaSupportProvider.ReaderResponse<T> response = provider.reader(type, headers);
            if (response.support() == MediaSupportProvider.SupportLevel.SUPPORTED) {
                return this.entityReader(response);
            }
            if (response.support() != MediaSupportProvider.SupportLevel.COMPATIBLE) continue;
            compatible = compatible == null ? response : compatible;
        }
        if (compatible == null) {
            return FailingReader.instance();
        }
        return this.entityReader(compatible);
    }

    @Override
    public <T> EntityWriter<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        MediaSupportProvider.WriterResponse<T> compatible = null;
        for (MediaSupportProvider provider : this.providers) {
            MediaSupportProvider.WriterResponse<T> response = provider.writer(type, requestHeaders, responseHeaders);
            if (response.support() == MediaSupportProvider.SupportLevel.SUPPORTED) {
                return this.entityWriter(response);
            }
            if (response.support() != MediaSupportProvider.SupportLevel.COMPATIBLE) continue;
            compatible = compatible == null ? response : compatible;
        }
        if (compatible == null) {
            return FailingWriter.instance();
        }
        return this.entityWriter(compatible);
    }

    @Override
    public <T> EntityReader<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        MediaSupportProvider.ReaderResponse<T> compatible = null;
        for (MediaSupportProvider provider : this.providers) {
            MediaSupportProvider.ReaderResponse<T> response = provider.reader(type, requestHeaders, responseHeaders);
            if (response.support() == MediaSupportProvider.SupportLevel.SUPPORTED) {
                return this.entityReader(response);
            }
            if (response.support() != MediaSupportProvider.SupportLevel.COMPATIBLE) continue;
            compatible = compatible == null ? response : compatible;
        }
        if (compatible == null) {
            return FailingReader.instance();
        }
        return this.entityReader(compatible);
    }

    @Override
    public <T> EntityWriter<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        MediaSupportProvider.WriterResponse<T> compatible = null;
        for (MediaSupportProvider provider : this.providers) {
            MediaSupportProvider.WriterResponse<T> response = provider.writer(type, requestHeaders);
            if (response.support() == MediaSupportProvider.SupportLevel.SUPPORTED) {
                return this.entityWriter(response);
            }
            if (response.support() != MediaSupportProvider.SupportLevel.COMPATIBLE) continue;
            compatible = compatible == null ? response : compatible;
        }
        if (compatible == null) {
            return FailingWriter.instance();
        }
        return this.entityWriter(compatible);
    }

    private <T> EntityWriter<T> entityWriter(MediaSupportProvider.WriterResponse<T> response) {
        return new CloseStreamWriter(response.supplier().get());
    }

    private <T> EntityReader<T> entityReader(MediaSupportProvider.ReaderResponse<T> response) {
        return new CloseStreamReader(response.supplier().get());
    }

    private static final class FailingReader
    implements EntityReader {
        private static final FailingReader INSTANCE = new FailingReader();

        private FailingReader() {
        }

        static <T> EntityReader<T> instance() {
            return INSTANCE;
        }

        public Object read(GenericType type, InputStream stream, Headers headers) {
            if (LOGGED_READERS.computeIfAbsent(type, it -> new AtomicBoolean()).compareAndSet(false, true)) {
                LOGGER.log(System.Logger.Level.WARNING, "There is no media reader configured for " + String.valueOf(type));
            }
            throw new IllegalArgumentException("No server request media support for " + String.valueOf(type) + " configured");
        }

        public Object read(GenericType type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
            if (LOGGED_READERS.computeIfAbsent(type, it -> new AtomicBoolean()).compareAndSet(false, true)) {
                LOGGER.log(System.Logger.Level.WARNING, "There is no media reader configured for " + String.valueOf(type));
            }
            throw new IllegalArgumentException("No client response media support for " + String.valueOf(type) + " configured");
        }
    }

    private static final class FailingWriter
    implements EntityWriter {
        private static final FailingWriter INSTANCE = new FailingWriter();

        private FailingWriter() {
        }

        static <T> EntityWriter<T> instance() {
            return INSTANCE;
        }

        public void write(GenericType type, Object object, OutputStream outputStream, Headers requestHeaders, WritableHeaders responseHeaders) {
            if (LOGGED_WRITERS.computeIfAbsent(type, it -> new AtomicBoolean()).compareAndSet(false, true)) {
                LOGGER.log(System.Logger.Level.WARNING, "There is no media writer configured for " + String.valueOf(type));
            }
            throw new IllegalArgumentException("No server response media writer for " + String.valueOf(type) + " configured");
        }

        public void write(GenericType type, Object object, OutputStream outputStream, WritableHeaders headers) {
            if (LOGGED_WRITERS.computeIfAbsent(type, it -> new AtomicBoolean()).compareAndSet(false, true)) {
                LOGGER.log(System.Logger.Level.WARNING, "There is no media writer configured for " + String.valueOf(type));
            }
            throw new IllegalArgumentException("No client request media writer for " + String.valueOf(type) + " configured");
        }
    }

    private static final class CloseStreamWriter
    implements EntityWriter {
        private final EntityWriter delegate;

        CloseStreamWriter(EntityWriter delegate) {
            this.delegate = delegate;
        }

        public void write(GenericType type, Object object, OutputStream outputStream, Headers requestHeaders, WritableHeaders responseHeaders) {
            this.delegate.write(type, object, outputStream, requestHeaders, responseHeaders);
        }

        public void write(GenericType type, Object object, OutputStream outputStream, WritableHeaders headers) {
            this.delegate.write(type, object, outputStream, headers);
        }
    }

    private static final class CloseStreamReader
    implements EntityReader {
        private final EntityReader delegate;

        CloseStreamReader(EntityReader delegate) {
            this.delegate = delegate;
        }

        public Object read(GenericType type, InputStream stream, Headers headers) {
            Object t;
            block8: {
                InputStream inputStream = stream;
                try {
                    t = this.delegate.read(type, stream, headers);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to read server request", e);
                    }
                }
                inputStream.close();
            }
            return t;
        }

        public Object read(GenericType type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
            Object t;
            block8: {
                InputStream inputStream = stream;
                try {
                    t = this.delegate.read(type, stream, requestHeaders, responseHeaders);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to read client response", e);
                    }
                }
                inputStream.close();
            }
            return t;
        }
    }
}

