/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media;

import io.helidon.common.GenericType;
import io.helidon.common.http.ContentDisposition;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.WritableHeaders;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.nima.http.media.EntityWriter;
import io.helidon.nima.http.media.spi.MediaSupportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathSupportProvider
implements MediaSupportProvider {
    private static final EntityWriter WRITER = new PathWriter();

    @Override
    public <T> MediaSupportProvider.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        return MediaSupportProvider.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupportProvider.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (Path.class.isAssignableFrom(type.rawType())) {
            return new MediaSupportProvider.WriterResponse(MediaSupportProvider.SupportLevel.SUPPORTED, PathSupportProvider::writer);
        }
        return MediaSupportProvider.WriterResponse.unsupported();
    }

    @Override
    public <T> MediaSupportProvider.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        return MediaSupportProvider.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupportProvider.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (Path.class.isAssignableFrom(type.rawType())) {
            return new MediaSupportProvider.WriterResponse(MediaSupportProvider.SupportLevel.SUPPORTED, PathSupportProvider::writer);
        }
        return MediaSupportProvider.WriterResponse.unsupported();
    }

    private static <T> EntityWriter<T> writer() {
        return WRITER;
    }

    private static final class PathWriter
    implements EntityWriter<Path> {
        private PathWriter() {
        }

        @Override
        public void write(GenericType<Path> type, Path object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            this.write(object, outputStream, responseHeaders);
        }

        @Override
        public void write(GenericType<Path> type, Path object, OutputStream outputStream, WritableHeaders<?> headers) {
            this.write(object, outputStream, headers);
        }

        private void write(Path toWrite, OutputStream outputStream, WritableHeaders<?> writableHeaders) {
            if (!writableHeaders.contains(Http.Header.CONTENT_TYPE)) {
                MediaType mediaType = MediaTypes.detectType((Path)toWrite).orElse(MediaTypes.APPLICATION_OCTET_STREAM);
                writableHeaders.contentType(mediaType);
            }
            if (!writableHeaders.contains(Http.Header.CONTENT_DISPOSITION)) {
                writableHeaders.set((Http.HeaderValue)ContentDisposition.builder().filename(String.valueOf(toWrite.getFileName())).build());
            }
            try (InputStream in = Files.newInputStream(toWrite, new OpenOption[0]);
                 OutputStream outputStream2 = outputStream;){
                in.transferTo(outputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

