/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media;

import io.helidon.common.GenericType;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.WritableHeaders;
import io.helidon.nima.http.media.EntityReader;
import io.helidon.nima.http.media.EntityWriter;
import io.helidon.nima.http.media.spi.MediaSupportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class StringSupportProvider
implements MediaSupportProvider {
    private static final EntityReader READER = new StringReader();
    private static final EntityWriter WRITER = new StringWriter();

    @Override
    public <T> MediaSupportProvider.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupportProvider.ReaderResponse(MediaSupportProvider.SupportLevel.SUPPORTED, StringSupportProvider::reader);
        }
        return MediaSupportProvider.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupportProvider.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupportProvider.WriterResponse(MediaSupportProvider.SupportLevel.SUPPORTED, StringSupportProvider::writer);
        }
        return MediaSupportProvider.WriterResponse.unsupported();
    }

    @Override
    public <T> MediaSupportProvider.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupportProvider.ReaderResponse(MediaSupportProvider.SupportLevel.SUPPORTED, StringSupportProvider::reader);
        }
        return MediaSupportProvider.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupportProvider.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupportProvider.WriterResponse(MediaSupportProvider.SupportLevel.SUPPORTED, StringSupportProvider::writer);
        }
        return MediaSupportProvider.WriterResponse.unsupported();
    }

    private static <T> EntityReader<T> reader() {
        return READER;
    }

    private static <T> EntityWriter<T> writer() {
        return WRITER;
    }

    private static final class StringReader
    implements EntityReader<String> {
        private StringReader() {
        }

        @Override
        public String read(GenericType<String> type, InputStream stream, Headers headers) {
            return this.read(stream, headers.contentType());
        }

        @Override
        public String read(GenericType<String> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
            return this.read(stream, responseHeaders.contentType());
        }

        private String read(InputStream stream, Optional<HttpMediaType> contentType) {
            String string;
            block8: {
                Charset charset = contentType.flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
                InputStream inputStream = stream;
                try {
                    string = new String(stream.readAllBytes(), charset);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return string;
        }
    }

    private static final class StringWriter
    implements EntityWriter<String> {
        private static final Http.HeaderValue HEADER_PLAIN_TEXT = Http.Header.createCached((Http.HeaderName)Http.Header.CONTENT_TYPE, (String)HttpMediaType.PLAINTEXT_UTF_8.text());

        private StringWriter() {
        }

        @Override
        public void write(GenericType<String> type, String object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            this.write(object, outputStream, responseHeaders);
        }

        @Override
        public void write(GenericType<String> type, String object, OutputStream outputStream, WritableHeaders<?> headers) {
            this.write(object, outputStream, headers);
        }

        private void write(String toWrite, OutputStream outputStream, WritableHeaders<?> writableHeaders) {
            Charset charset;
            if (writableHeaders.contains(Http.Header.CONTENT_TYPE)) {
                charset = writableHeaders.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            } else {
                writableHeaders.set(HEADER_PLAIN_TEXT);
                charset = StandardCharsets.UTF_8;
            }
            try (OutputStream outputStream2 = outputStream;){
                outputStream.write(toWrite.getBytes(charset));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

