/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.http.media.spi;

import io.helidon.common.GenericType;
import io.helidon.common.http.Headers;
import io.helidon.common.http.WritableHeaders;
import io.helidon.nima.http.media.EntityReader;
import io.helidon.nima.http.media.EntityWriter;
import io.helidon.nima.http.media.MediaContext;
import java.util.function.Supplier;

public interface MediaSupportProvider {
    default public void init(MediaContext context) {
    }

    default public <T> ReaderResponse<T> reader(GenericType<T> type, Headers headers) {
        return ReaderResponse.unsupported();
    }

    default public <T> WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        return WriterResponse.unsupported();
    }

    default public <T> ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        return ReaderResponse.unsupported();
    }

    default public <T> WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        return WriterResponse.unsupported();
    }

    public record ReaderResponse<T>(SupportLevel support, Supplier<EntityReader<T>> supplier) {
        private static final ReaderResponse NOT_SUPPORTED = new ReaderResponse(SupportLevel.NOT_SUPPORTED, null);

        public static <T> ReaderResponse<T> unsupported() {
            return NOT_SUPPORTED;
        }
    }

    public record WriterResponse<T>(SupportLevel support, Supplier<EntityWriter<T>> supplier) {
        private static final WriterResponse NOT_SUPPORTED = new WriterResponse(SupportLevel.NOT_SUPPORTED, null);

        public static <T> WriterResponse<T> unsupported() {
            return NOT_SUPPORTED;
        }
    }

    public static enum SupportLevel {
        NOT_SUPPORTED,
        COMPATIBLE,
        SUPPORTED;

    }
}

