/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.observe.health;

import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.nima.observe.health.HealthFeature;
import io.helidon.nima.observe.spi.ObserveProvider;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.HttpRouting;
import java.util.function.Supplier;

public class HealthObserveProvider
implements ObserveProvider {
    private final HealthFeature explicitService;

    @Deprecated
    public HealthObserveProvider() {
        this(null);
    }

    private HealthObserveProvider(HealthFeature explicitService) {
        this.explicitService = explicitService;
    }

    public static ObserveProvider create() {
        return HealthObserveProvider.create(HealthFeature.create(new HealthCheck[0]));
    }

    public static ObserveProvider create(HealthFeature service) {
        return new HealthObserveProvider(service);
    }

    public String configKey() {
        return "health";
    }

    public String defaultEndpoint() {
        return this.explicitService == null ? "health" : this.explicitService.configuredContext();
    }

    public void register(Config config, String componentPath, HttpRouting.Builder routing) {
        HealthFeature observer;
        HealthFeature healthFeature = observer = this.explicitService == null ? ((HealthFeature.Builder)HealthFeature.builder().webContext(componentPath)).config(config).build() : this.explicitService;
        if (observer.enabled()) {
            observer.context(componentPath);
            routing.addFeature((Supplier)((Object)observer));
        } else {
            routing.get(componentPath + "/*", new Handler[]{(req, res) -> res.status(Http.Status.SERVICE_UNAVAILABLE_503).send()});
        }
    }
}

