/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.observe.health;

import io.helidon.common.http.Headers;
import io.helidon.common.http.HtmlEncoder;
import io.helidon.common.http.Http;
import io.helidon.common.http.NotFoundException;
import io.helidon.common.http.WritableHeaders;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.nima.http.media.EntityWriter;
import io.helidon.nima.http.media.jsonp.JsonpMediaSupportProvider;
import io.helidon.nima.observe.health.HealthHelper;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SingleCheckHandler
implements Handler {
    private static final System.Logger LOGGER = System.getLogger(SingleCheckHandler.class.getName());
    private final EntityWriter<JsonObject> entityWriter;
    private final boolean details;
    private final List<HealthCheck> allChecks;
    private final Map<String, HealthCheck> checks;

    SingleCheckHandler(EntityWriter<JsonObject> entityWriter, boolean details, List<HealthCheck> checks) {
        this.entityWriter = entityWriter;
        this.details = details;
        this.allChecks = checks;
        this.checks = new HashMap<String, HealthCheck>();
    }

    public void beforeStart() {
        this.allChecks.forEach(it -> this.checks.putIfAbsent(it.path(), (HealthCheck)it));
    }

    public void handle(ServerRequest req, ServerResponse res) {
        HealthCheckResponse response;
        String name = req.path().pathParameters().value("name");
        HealthCheck check = this.checks.get(name);
        if (check == null) {
            throw new NotFoundException(name);
        }
        try {
            response = check.call();
        }
        catch (Exception e) {
            response = HealthCheckResponse.builder().status(HealthCheckResponse.Status.ERROR).detail("error", (Object)e.getClass().getName()).detail("message", (Object)HtmlEncoder.encode((String)e.getMessage())).build();
            LOGGER.log(System.Logger.Level.ERROR, "Unexpected failure of health check", (Throwable)e);
        }
        Http.Status responseStatus = switch (response.status()) {
            default -> throw new IncompatibleClassChangeError();
            case HealthCheckResponse.Status.UP -> {
                if (this.details) {
                    yield Http.Status.OK_200;
                }
                yield Http.Status.NO_CONTENT_204;
            }
            case HealthCheckResponse.Status.DOWN -> Http.Status.SERVICE_UNAVAILABLE_503;
            case HealthCheckResponse.Status.ERROR -> Http.Status.INTERNAL_SERVER_ERROR_500;
        };
        res.status(responseStatus);
        if (this.details) {
            try (OutputStream out = res.outputStream();){
                this.entityWriter.write(JsonpMediaSupportProvider.JSON_OBJECT_TYPE, (Object)HealthHelper.toJson(check.name(), response), out, (Headers)req.headers(), (WritableHeaders)res.headers());
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.TRACE, "Failed to write health check response", (Throwable)e);
                res.status(Http.Status.INTERNAL_SERVER_ERROR_500).send();
            }
        } else {
            res.send();
        }
    }
}

