/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.observe.metrics;

import io.helidon.common.LazyValue;
import io.helidon.common.http.Http;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.Config;
import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.RegistryFactory;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.serviceapi.JsonFormat;
import io.helidon.metrics.serviceapi.PrometheusFormat;
import io.helidon.nima.observe.metrics.KeyPerformanceIndicatorMetricsImpls;
import io.helidon.nima.observe.metrics.PostRequestMetricsSupport;
import io.helidon.nima.servicecommon.HelidonFeatureSupport;
import io.helidon.nima.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.HttpRouting;
import io.helidon.nima.webserver.http.HttpRules;
import io.helidon.nima.webserver.http.HttpService;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MetricsFeature
extends HelidonFeatureSupport {
    private static final System.Logger LOGGER = System.getLogger(MetricsFeature.class.getName());
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final Handler DISABLED_ENDPOINT_HANDLER = (req, res) -> res.status(Http.Status.NOT_FOUND_404).send((Object)"Metrics are disabled");
    private final MetricsSettings metricsSettings;
    private final RegistryFactory registryFactory;

    private MetricsFeature(Builder builder) {
        super(LOGGER, (HelidonFeatureSupport.Builder)builder, "Metrics");
        this.registryFactory = builder.registryFactory();
        this.metricsSettings = builder.metricsSettings();
        SystemTagsManager.create((MetricsSettings)this.metricsSettings);
    }

    public static MetricsFeature create() {
        return MetricsFeature.builder().build();
    }

    public static MetricsFeature create(Config config) {
        return MetricsFeature.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<HttpService> service() {
        return Optional.of(rules -> {
            if (this.registryFactory.enabled()) {
                this.setUpEndpoints(rules);
            } else {
                this.setUpDisabledEndpoints(rules);
            }
        });
    }

    public void configureVendorMetrics(HttpRouting.Builder rules) {
        String metricPrefix = "requests.";
        KeyPerformanceIndicatorSupport.Metrics kpiMetrics = KeyPerformanceIndicatorMetricsImpls.get(metricPrefix, this.metricsSettings.keyPerformanceIndicatorSettings());
        rules.addFilter((chain, req, res) -> {
            KeyPerformanceIndicatorSupport.Context kpiContext = MetricsFeature.kpiContext((ServerRequest)req);
            PostRequestMetricsSupport prms = PostRequestMetricsSupport.create();
            req.context().register((Object)prms);
            kpiContext.requestHandlingStarted(kpiMetrics);
            try {
                chain.proceed();
                this.postRequestProcessing(prms, (ServerRequest)req, (ServerResponse)res, null, kpiContext);
            }
            catch (Exception e) {
                this.postRequestProcessing(prms, (ServerRequest)req, (ServerResponse)res, e, kpiContext);
            }
        });
    }

    public void beforeStart() {
        if (this.registryFactory.enabled()) {
            this.registryFactory.start();
        }
    }

    public void afterStop() {
        if (this.registryFactory.enabled()) {
            this.registryFactory.stop();
        }
    }

    protected void postSetup(HttpRouting.Builder defaultRouting, HttpRouting.Builder featureRouting) {
        this.configureVendorMetrics(defaultRouting);
    }

    private static void getAll(ServerRequest req, ServerResponse res, Registry registry) {
        res.header(Http.HeaderValues.CACHE_NO_CACHE);
        if (registry.empty()) {
            res.status(Http.Status.NO_CONTENT_204);
            res.send();
            return;
        }
        MediaType mediaType = MetricsFeature.bestAccepted(req);
        if (mediaType == MediaTypes.APPLICATION_JSON) {
            MetricsFeature.sendJson(res, JsonFormat.jsonData((Registry)registry));
        } else if (mediaType == MediaTypes.TEXT_PLAIN) {
            res.send((Object)PrometheusFormat.prometheusData((Registry[])new Registry[]{registry}));
        } else {
            res.status(Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private static MediaType bestAccepted(ServerRequest req) {
        return req.headers().bestAccepted(new MediaType[]{MediaTypes.TEXT_PLAIN, MediaTypes.APPLICATION_JSON}).orElse(null);
    }

    private static void sendJson(ServerResponse res, JsonObject object) {
        res.send((Object)object);
    }

    private static KeyPerformanceIndicatorSupport.Context kpiContext(ServerRequest request) {
        return request.context().get(KeyPerformanceIndicatorSupport.Context.class).orElseGet(KeyPerformanceIndicatorSupport.Context::create);
    }

    private void setUpEndpoints(HttpRules rules) {
        Registry base = this.registryFactory.getRegistry(MetricRegistry.Type.BASE);
        Registry vendor = this.registryFactory.getRegistry(MetricRegistry.Type.VENDOR);
        Registry app = this.registryFactory.getRegistry(MetricRegistry.Type.APPLICATION);
        rules.get("/", new Handler[]{(req, res) -> this.getMultiple(req, res, base, app, vendor)}).options("/", new Handler[]{(req, res) -> this.optionsMultiple(req, res, base, app, vendor)});
        Stream.of(app, base, vendor).forEach(registry -> {
            String type = registry.type();
            rules.get("/" + type, new Handler[]{(req, res) -> MetricsFeature.getAll(req, res, registry)}).get("/" + type + "/{metric}", new Handler[]{(req, res) -> this.getByName(req, res, (Registry)registry)}).options("/" + type, new Handler[]{(req, res) -> this.optionsAll(req, res, (Registry)registry)}).options("/" + type + "/{metric}", new Handler[]{(req, res) -> this.optionsOne(req, res, (Registry)registry)});
        });
    }

    private void getByName(ServerRequest req, ServerResponse res, Registry registry) {
        String metricName = req.path().pathParameters().value("metric");
        res.header(Http.HeaderValues.CACHE_NO_CACHE);
        registry.find(metricName).ifPresentOrElse(entry -> {
            MediaType mediaType = MetricsFeature.bestAccepted(req);
            if (mediaType == MediaTypes.APPLICATION_JSON) {
                MetricsFeature.sendJson(res, JsonFormat.jsonDataByName((Registry)registry, (String)metricName));
            } else if (mediaType == MediaTypes.TEXT_PLAIN) {
                res.send((Object)PrometheusFormat.prometheusDataByName((Registry)registry, (String)metricName));
            } else {
                res.status(Http.Status.NOT_ACCEPTABLE_406);
                res.send();
            }
        }, () -> {
            res.status(Http.Status.NOT_FOUND_404);
            res.send();
        });
    }

    private void optionsAll(ServerRequest req, ServerResponse res, Registry registry) {
        if (registry.empty()) {
            res.status(Http.Status.NO_CONTENT_204);
            res.send();
            return;
        }
        if (req.headers().isAccepted(MediaTypes.APPLICATION_JSON)) {
            MetricsFeature.sendJson(res, JsonFormat.jsonMeta((Registry)registry));
        } else {
            res.status(Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void postRequestProcessing(PostRequestMetricsSupport prms, ServerRequest request, ServerResponse response, Throwable throwable, KeyPerformanceIndicatorSupport.Context kpiContext) {
        kpiContext.requestProcessingCompleted(throwable == null && response.status().code() < 500);
        prms.runTasks(request, response, throwable);
    }

    private void getMultiple(ServerRequest req, ServerResponse res, Registry ... registries) {
        MediaType mediaType = MetricsFeature.bestAccepted(req);
        res.header(Http.HeaderValues.CACHE_NO_CACHE);
        if (mediaType == MediaTypes.APPLICATION_JSON) {
            MetricsFeature.sendJson(res, JsonFormat.jsonData((Registry[])registries));
        } else if (mediaType == MediaTypes.TEXT_PLAIN) {
            res.send((Object)PrometheusFormat.prometheusData((Registry[])registries));
        } else {
            res.status(Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void optionsMultiple(ServerRequest req, ServerResponse res, Registry ... registries) {
        if (req.headers().isAccepted(MediaTypes.APPLICATION_JSON)) {
            MetricsFeature.sendJson(res, JsonFormat.jsonMeta((Registry[])registries));
        } else {
            res.status(Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void optionsOne(ServerRequest req, ServerResponse res, Registry registry) {
        String metricName = req.path().pathParameters().value("metric");
        registry.metricsByName(metricName).ifPresentOrElse(entry -> {
            if (req.headers().isAccepted(MediaTypes.APPLICATION_JSON)) {
                JsonObjectBuilder builder = JSON.createObjectBuilder();
                MetricID metricId = (MetricID)entry.metricIds().get(0);
                JsonFormat.jsonMeta((JsonObjectBuilder)builder, (HelidonMetric)registry.getMetric(metricId), (List)entry.metricIds());
                MetricsFeature.sendJson(res, builder.build());
            } else {
                res.status(Http.Status.NOT_ACCEPTABLE_406).send();
            }
        }, () -> res.status(Http.Status.NOT_FOUND_404).send());
    }

    private void setUpDisabledEndpoints(HttpRules rules) {
        rules.get("/", new Handler[]{DISABLED_ENDPOINT_HANDLER}).options("/", new Handler[]{DISABLED_ENDPOINT_HANDLER});
        Stream.of(MetricRegistry.Type.values()).map(Enum::name).map(String::toLowerCase).forEach(type -> Stream.of("", "/{metric}").map(suffix -> "/" + type + suffix).forEach(path -> rules.get(path, new Handler[]{DISABLED_ENDPOINT_HANDLER}).options(path, new Handler[]{DISABLED_ENDPOINT_HANDLER})));
    }

    public static final class Builder
    extends HelidonFeatureSupport.Builder<Builder, MetricsFeature> {
        private LazyValue<RegistryFactory> registryFactory;
        private MetricsSettings.Builder metricsSettingsBuilder = MetricsSettings.builder();

        private Builder() {
            super("/metrics");
        }

        public MetricsFeature build() {
            if (this.registryFactory == null) {
                this.registryFactory = LazyValue.create(() -> RegistryFactory.getInstance((MetricsSettings)this.metricsSettingsBuilder.build()));
            }
            return new MetricsFeature(this);
        }

        public Builder config(Config config) {
            super.config(config);
            this.metricsSettingsBuilder.config(config);
            return this;
        }

        public Builder metricsSettings(MetricsSettings.Builder metricsSettingsBuilder) {
            this.metricsSettingsBuilder = metricsSettingsBuilder;
            return this;
        }

        public Builder registryFactory(RegistryFactory factory) {
            this.registryFactory = LazyValue.create(() -> factory);
            return this;
        }

        RegistryFactory registryFactory() {
            return (RegistryFactory)this.registryFactory.get();
        }

        MetricsSettings metricsSettings() {
            return this.metricsSettingsBuilder.build();
        }
    }
}

