/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.observe.metrics;

import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.nima.observe.metrics.MetricsFeature;
import io.helidon.nima.observe.spi.ObserveProvider;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.HttpRouting;
import java.util.function.Supplier;

public class MetricsObserveProvider
implements ObserveProvider {
    private final MetricsFeature explicitService;

    @Deprecated
    public MetricsObserveProvider() {
        this(null);
    }

    private MetricsObserveProvider(MetricsFeature explicitService) {
        this.explicitService = explicitService;
    }

    public static ObserveProvider create() {
        return MetricsObserveProvider.create(MetricsFeature.create());
    }

    public static ObserveProvider create(MetricsFeature service) {
        return new MetricsObserveProvider(service);
    }

    public String configKey() {
        return "metrics";
    }

    public String defaultEndpoint() {
        return this.explicitService == null ? "metrics" : this.explicitService.configuredContext();
    }

    public void register(Config config, String componentPath, HttpRouting.Builder routing) {
        MetricsFeature observer;
        MetricsFeature metricsFeature = observer = this.explicitService == null ? ((MetricsFeature.Builder)MetricsFeature.builder().webContext(componentPath)).config(config).build() : this.explicitService;
        if (observer.enabled()) {
            routing.addFeature((Supplier)((Object)observer));
        } else {
            String finalPath = componentPath + (componentPath.endsWith("/") ? "*" : "/*");
            routing.get(finalPath, new Handler[]{(req, res) -> res.status(Http.Status.SERVICE_UNAVAILABLE_503).send()});
        }
    }
}

