/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpException;
import io.helidon.common.http.ServerRequestHeaders;
import io.helidon.common.http.ServerResponseHeaders;
import io.helidon.common.media.type.MediaType;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.helidon.nima.webserver.staticcontent.ByteRangeRequest;
import io.helidon.nima.webserver.staticcontent.CachedHandler;
import io.helidon.nima.webserver.staticcontent.StaticContentHandler;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

record CachedHandlerInMemory(MediaType mediaType, Instant lastModified, BiConsumer<ServerResponseHeaders, Instant> setLastModifiedHeader, byte[] bytes, int contentLength, Http.HeaderValue contentLengthHeader) implements CachedHandler
{
    @Override
    public boolean handle(LruCache<String, CachedHandler> cache, Http.Method method, ServerRequest request, ServerResponse response, String requestedResource) {
        if (this.lastModified != null) {
            StaticContentHandler.processEtag(String.valueOf(this.lastModified.toEpochMilli()), request.headers(), response.headers());
            StaticContentHandler.processModifyHeaders(this.lastModified, request.headers(), response.headers(), this.setLastModifiedHeader);
        }
        response.headers().contentType(this.mediaType);
        if (method == Http.Method.GET) {
            this.send(request, response);
        } else {
            response.headers().set(this.contentLengthHeader());
            response.send();
        }
        return true;
    }

    private void send(ServerRequest request, ServerResponse response) {
        ServerRequestHeaders headers = request.headers();
        if (headers.contains(Http.Header.RANGE)) {
            long contentLength = this.contentLength();
            List<ByteRangeRequest> ranges = ByteRangeRequest.parse(request, response, headers.get(Http.Header.RANGE).values(), contentLength);
            if (ranges.size() == 1) {
                ByteRangeRequest range = ranges.get(0);
                if (range.offset() > (long)this.contentLength()) {
                    throw new HttpException("Invalid range offset", Http.Status.REQUESTED_RANGE_NOT_SATISFIABLE_416, true);
                }
                if (range.length() > (long)this.contentLength() - range.offset()) {
                    throw new HttpException("Invalid length", Http.Status.REQUESTED_RANGE_NOT_SATISFIABLE_416, true);
                }
                range.setContentRange(response);
                response.send(Arrays.copyOfRange(this.bytes(), (int)range.offset(), (int)range.length()));
            } else {
                this.send(response);
            }
        } else {
            this.send(response);
        }
    }

    private void send(ServerResponse response) {
        response.headers().set(this.contentLengthHeader());
        response.send(this.bytes());
    }
}

