/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.http.Http;
import io.helidon.common.http.ServerResponseHeaders;
import io.helidon.common.media.type.MediaType;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.helidon.nima.webserver.staticcontent.CachedHandler;
import io.helidon.nima.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.nima.webserver.staticcontent.StaticContentHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.function.BiConsumer;

record CachedHandlerJar(Path path, MediaType mediaType, Instant lastModified, BiConsumer<ServerResponseHeaders, Instant> setLastModifiedHeader) implements CachedHandler
{
    private static final System.Logger LOGGER = System.getLogger(CachedHandlerJar.class.getName());

    @Override
    public boolean handle(LruCache<String, CachedHandler> cache, Http.Method method, ServerRequest request, ServerResponse response, String requestedResource) throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            cache.remove((Object)requestedResource);
            return false;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Sending static content from jar: " + requestedResource);
        }
        if (this.lastModified != null) {
            StaticContentHandler.processEtag(String.valueOf(this.lastModified.toEpochMilli()), request.headers(), response.headers());
            StaticContentHandler.processModifyHeaders(this.lastModified, request.headers(), response.headers(), this.setLastModifiedHeader());
        }
        response.headers().contentType(this.mediaType);
        if (method == Http.Method.GET) {
            FileBasedContentHandler.send(request, response, this.path);
        } else {
            response.headers().contentLength(FileBasedContentHandler.contentLength(this.path));
            response.send();
        }
        return true;
    }
}

