/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.webserver.staticcontent;

import io.helidon.common.http.Http;
import io.helidon.common.http.ServerResponseHeaders;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.helidon.nima.webserver.staticcontent.CachedHandler;
import io.helidon.nima.webserver.staticcontent.CachedHandlerPath;
import io.helidon.nima.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.nima.webserver.staticcontent.StaticContentService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

class SingleFileContentHandler
extends FileBasedContentHandler {
    private static final System.Logger LOGGER = System.getLogger(SingleFileContentHandler.class.getName());
    private final boolean cacheInMemory;
    private final Path path;

    SingleFileContentHandler(StaticContentService.FileSystemBuilder builder) {
        super(builder);
        this.cacheInMemory = builder.cacheInMemory().contains(".") || builder.cacheInMemory().contains("/");
        this.path = builder.root().toAbsolutePath().normalize();
    }

    @Override
    public void beforeStart() {
        try {
            if (this.cacheInMemory) {
                byte[] fileBytes = Files.readAllBytes(this.path);
                this.cacheInMemory(".", this.detectType(SingleFileContentHandler.fileName(this.path)), fileBytes, SingleFileContentHandler.lastModified(this.path));
            } else {
                this.cacheFileHandler();
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Failed to add file to in-memory cache, path: " + String.valueOf(this.path), (Throwable)e);
        }
        super.beforeStart();
    }

    @Override
    boolean doHandle(Http.Method method, String requestedPath, ServerRequest req, ServerResponse res) throws IOException {
        if ("".equals(requestedPath) || "/".equals(requestedPath)) {
            Optional<CachedHandler> cachedHandler = this.cacheHandler(".");
            if (cachedHandler.isPresent()) {
                return cachedHandler.get().handle(this.handlerCache(), method, req, res, requestedPath);
            }
            return this.doHandle(method, req, res);
        }
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Requested sub-path for a single file static content: " + requestedPath);
        }
        return false;
    }

    private boolean doHandle(Http.Method method, ServerRequest req, ServerResponse res) throws IOException {
        return this.cacheFileHandler().handle(this.handlerCache(), method, req, res, ".");
    }

    private CachedHandler cacheFileHandler() {
        CachedHandlerPath handler = new CachedHandlerPath(this.path, this.detectType(SingleFileContentHandler.fileName(this.path)), FileBasedContentHandler::lastModified, ServerResponseHeaders::lastModified);
        this.cacheHandler(".", handler);
        return handler;
    }
}

