/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.nima.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpException;
import io.helidon.common.http.InternalServerException;
import io.helidon.common.http.NotFoundException;
import io.helidon.common.http.PathMatchers;
import io.helidon.common.http.ServerRequestHeaders;
import io.helidon.common.http.ServerResponseHeaders;
import io.helidon.common.media.type.MediaType;
import io.helidon.nima.webserver.http.HttpRules;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.helidon.nima.webserver.staticcontent.CachedHandler;
import io.helidon.nima.webserver.staticcontent.CachedHandlerInMemory;
import io.helidon.nima.webserver.staticcontent.StaticContentService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class StaticContentHandler
implements StaticContentService {
    private static final System.Logger LOGGER = System.getLogger(StaticContentHandler.class.getName());
    private final Map<String, CachedHandlerInMemory> inMemoryCache = new ConcurrentHashMap<String, CachedHandlerInMemory>();
    private final LruCache<String, CachedHandler> handlerCache;
    private final String welcomeFilename;
    private final Function<String, String> resolvePathFunction;
    private final AtomicInteger webServerCounter = new AtomicInteger();

    StaticContentHandler(StaticContentService.Builder<?> builder) {
        this.welcomeFilename = builder.welcomeFileName();
        this.resolvePathFunction = builder.resolvePathFunction();
        this.handlerCache = builder.handlerCache();
    }

    static void processEtag(String etag, ServerRequestHeaders requestHeaders, ServerResponseHeaders responseHeaders) {
        List ifMatches;
        if (etag == null || etag.isEmpty()) {
            return;
        }
        etag = StaticContentHandler.unquoteETag(etag);
        responseHeaders.set(Http.Header.ETAG, new String[]{"\"" + etag + "\""});
        if (requestHeaders.contains(Http.Header.IF_NONE_MATCH)) {
            List ifNoneMatches = requestHeaders.get(Http.Header.IF_NONE_MATCH).allValues();
            for (String ifNoneMatch : ifNoneMatches) {
                if (!"*".equals(ifNoneMatch = StaticContentHandler.unquoteETag(ifNoneMatch)) && !ifNoneMatch.equals(etag)) continue;
                throw new HttpException("Accepted by If-None-Match header", Http.Status.NOT_MODIFIED_304, true);
            }
        }
        if (requestHeaders.contains(Http.Header.IF_MATCH) && !(ifMatches = requestHeaders.get(Http.Header.IF_MATCH).allValues()).isEmpty()) {
            boolean ifMatchChecked = false;
            for (String ifMatch : ifMatches) {
                if (!"*".equals(ifMatch = StaticContentHandler.unquoteETag(ifMatch)) && !ifMatch.equals(etag)) continue;
                ifMatchChecked = true;
                break;
            }
            if (!ifMatchChecked) {
                throw new HttpException("Not accepted by If-Match header", Http.Status.PRECONDITION_FAILED_412, true);
            }
        }
    }

    static void processModifyHeaders(Instant modified, ServerRequestHeaders requestHeaders, ServerResponseHeaders responseHeaders, BiConsumer<ServerResponseHeaders, Instant> setModified) {
        if (modified == null) {
            return;
        }
        setModified.accept(responseHeaders, modified);
        Optional<Instant> ifModSince = requestHeaders.ifModifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifModSince.isPresent() && !ifModSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Modified-Since header", Http.Status.NOT_MODIFIED_304, true);
        }
        Optional<Instant> ifUnmodSince = requestHeaders.ifUnmodifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifUnmodSince.isPresent() && ifUnmodSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Unmodified-Since header", Http.Status.PRECONDITION_FAILED_412, true);
        }
    }

    static void processModifyHeaders(Instant modified, ServerRequestHeaders requestHeaders, ServerResponseHeaders responseHeaders) {
        StaticContentHandler.processModifyHeaders(modified, requestHeaders, responseHeaders, ServerResponseHeaders::lastModified);
    }

    static void throwNotFoundIf(boolean condition) {
        if (condition) {
            throw new NotFoundException("Static content not found");
        }
    }

    public void beforeStart() {
        this.webServerCounter.incrementAndGet();
    }

    public void afterStop() {
        int i = this.webServerCounter.decrementAndGet();
        if (i <= 0) {
            this.webServerCounter.set(0);
            this.releaseCache();
        }
    }

    public void routing(HttpRules rules) {
        rules.route((Predicate)Http.Method.predicate((Http.Method[])new Http.Method[]{Http.Method.GET, Http.Method.HEAD}), PathMatchers.any(), this::handle);
    }

    void releaseCache() {
        this.handlerCache.clear();
        this.inMemoryCache.clear();
    }

    void handle(ServerRequest request, ServerResponse response) {
        Http.Method method = request.prologue().method();
        String requestPath = request.path().rawPathNoParams();
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        requestPath = this.resolvePathFunction.apply(requestPath);
        try {
            if (!this.doHandle(method, requestPath, request, response)) {
                response.next();
            }
        }
        catch (HttpException httpException) {
            if (httpException.status().code() == Http.Status.NOT_FOUND_404.code()) {
                response.next();
            }
            throw httpException;
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to access static resource", (Throwable)e);
            throw new InternalServerException("Cannot access static resource", (Throwable)e);
        }
    }

    abstract boolean doHandle(Http.Method var1, String var2, ServerRequest var3, ServerResponse var4) throws IOException, URISyntaxException;

    String welcomePageName() {
        return this.welcomeFilename;
    }

    void cacheInMemory(String resource, CachedHandlerInMemory handler) {
        this.inMemoryCache.put(resource, handler);
    }

    Optional<CachedHandlerInMemory> cacheInMemory(String resource) {
        return Optional.ofNullable(this.inMemoryCache.get(resource));
    }

    Optional<CachedHandler> cacheHandler(String resource) {
        return this.cacheInMemory(resource).map(CachedHandler.class::cast).or(() -> this.handlerCache.get((Object)resource));
    }

    void cacheHandler(String resource, CachedHandler cachedResource) {
        this.handlerCache.put((Object)resource, (Object)cachedResource);
    }

    LruCache<String, CachedHandler> handlerCache() {
        return this.handlerCache;
    }

    private static String unquoteETag(String etag) {
        if (etag == null || etag.isEmpty()) {
            return etag;
        }
        if (etag.startsWith("W/") || etag.startsWith("w/")) {
            etag = etag.substring(2);
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    void cacheInMemory(String resource, MediaType contentType, byte[] bytes, Optional<Instant> lastModified) {
        CachedHandlerInMemory inMemoryResource;
        int contentLength = bytes.length;
        Http.HeaderValue contentLengthHeader = Http.Header.create((Http.HeaderName)Http.Header.CONTENT_LENGTH, (int)contentLength);
        if (lastModified.isEmpty()) {
            inMemoryResource = new CachedHandlerInMemory(contentType, null, null, bytes, contentLength, contentLengthHeader);
        } else {
            Http.HeaderValue lastModifiedHeader = Http.Header.create((Http.HeaderName)Http.Header.LAST_MODIFIED, (boolean)true, (boolean)false, (String[])new String[]{StaticContentHandler.formatLastModified(lastModified.get())});
            inMemoryResource = new CachedHandlerInMemory(contentType, lastModified.get(), (headers, instant) -> headers.set(lastModifiedHeader), bytes, contentLength, contentLengthHeader);
        }
        this.cacheInMemory(resource, inMemoryResource);
    }

    static String formatLastModified(Instant lastModified) {
        ZonedDateTime dt = ZonedDateTime.ofInstant(lastModified, ZoneId.systemDefault());
        return dt.format(Http.DateTime.RFC_1123_DATE_TIME);
    }
}

