/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.builder.config.spi.AbstractConfigResolverRequest;
import io.helidon.pico.builder.config.spi.ConfigResolverMapRequest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractConfigResolverMapRequest
extends AbstractConfigResolverRequest
implements ConfigResolverMapRequest {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractConfigResolverMapRequest.__calcMeta());
    private final Class keyType;
    private final Optional<Class<?>> keyComponentType;

    protected AbstractConfigResolverMapRequest(Builder<?, ?> b) {
        super(b);
        this.keyType = b.keyType;
        this.keyComponentType = b.keyComponentType;
    }

    public Class keyType() {
        return this.keyType;
    }

    @Override
    public Optional<Class<?>> keyComponentType() {
        return this.keyComponentType;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("configKey", Map.of("type", String.class));
        metaProps.put("attributeName", Map.of("type", String.class));
        metaProps.put("valueType", Map.of("type", Class.class));
        metaProps.put("valueComponentType", Map.of("type", Optional.class, "componentType", Class.class));
        metaProps.put("keyType", Map.of("type", Class.class));
        metaProps.put("keyComponentType", Map.of("type", Optional.class, "componentType", Class.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    @Override
    public String toString() {
        return ConfigResolverMapRequest.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    @Override
    protected String toStringInner() {
        Object result = super.toStringInner();
        if (!((String)result).isEmpty() && !((String)result).endsWith(", ")) {
            result = (String)result + ", ";
        }
        result = (String)result + "keyType=" + String.valueOf(this.keyType()) + ", ";
        result = (String)result + "keyComponentType=" + String.valueOf(this.keyComponentType());
        return result;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + Objects.hash(this.keyType(), this.keyComponentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ConfigResolverMapRequest)) {
            return false;
        }
        ConfigResolverMapRequest other = (ConfigResolverMapRequest)another;
        boolean equals = super.equals(other);
        equals &= Objects.equals(this.keyType(), other.keyType());
        return equals &= Objects.equals(this.keyComponentType(), other.keyComponentType());
    }

    @Override
    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        super.visitAttributes(visitor, userDefinedCtx);
        visitor.visit("keyType", () -> this.keyType(), __META_PROPS.get("keyType"), userDefinedCtx, Class.class, new Class[0]);
        visitor.visit("keyComponentType", () -> this.keyComponentType(), __META_PROPS.get("keyComponentType"), userDefinedCtx, Optional.class, new Class[]{Class.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ConfigResolverMapRequest>
    extends AbstractConfigResolverRequest.Builder<B, T>
    implements ConfigResolverMapRequest {
        private Class keyType;
        private Optional keyComponentType = Optional.empty();

        protected Builder() {
        }

        public Class keyType() {
            return this.keyType;
        }

        @Override
        public Optional<Class<?>> keyComponentType() {
            return this.keyComponentType;
        }

        public B keyType(Class val) {
            this.keyType = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B keyComponentType(Optional<Class<?>> val) {
            this.keyComponentType = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B keyComponentType(Class<?> val) {
            Objects.requireNonNull(val);
            return this.keyComponentType(Optional.of(val));
        }

        @Override
        public B accept(T val) {
            Objects.requireNonNull(val);
            super.accept(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.keyType(val.keyType());
            this.keyComponentType(val.keyComponentType());
        }

        @Override
        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            super.visitAttributes(visitor, userDefinedCtx);
            visitor.visit("keyType", () -> this.keyType, __META_PROPS.get("keyType"), userDefinedCtx, Class.class, new Class[0]);
            visitor.visit("keyComponentType", () -> this.keyComponentType, __META_PROPS.get("keyComponentType"), userDefinedCtx, Optional.class, new Class[]{Class.class});
        }
    }
}

