/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.builder.config.spi.ConfigResolverRequest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractConfigResolverRequest
implements ConfigResolverRequest {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractConfigResolverRequest.__calcMeta());
    private final String configKey;
    private final String attributeName;
    private final Class valueType;
    private final Optional<Class<?>> valueComponentType;

    protected AbstractConfigResolverRequest(Builder<?, ?> b) {
        this.configKey = b.configKey;
        this.attributeName = b.attributeName;
        this.valueType = b.valueType;
        this.valueComponentType = b.valueComponentType;
    }

    @Override
    public String configKey() {
        return this.configKey;
    }

    @Override
    public String attributeName() {
        return this.attributeName;
    }

    public Class valueType() {
        return this.valueType;
    }

    @Override
    public Optional<Class<?>> valueComponentType() {
        return this.valueComponentType;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("configKey", Map.of("type", String.class));
        metaProps.put("attributeName", Map.of("type", String.class));
        metaProps.put("valueType", Map.of("type", Class.class));
        metaProps.put("valueComponentType", Map.of("type", Optional.class, "componentType", Class.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ConfigResolverRequest.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "configKey=" + this.configKey() + ", ";
        result = (String)result + "attributeName=" + this.attributeName() + ", ";
        result = (String)result + "valueType=" + String.valueOf(this.valueType()) + ", ";
        result = (String)result + "valueComponentType=" + String.valueOf(this.valueComponentType());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.configKey(), this.attributeName(), this.valueType(), this.valueComponentType());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ConfigResolverRequest)) {
            return false;
        }
        ConfigResolverRequest other = (ConfigResolverRequest)another;
        boolean equals = true;
        equals &= Objects.equals(this.configKey(), other.configKey());
        equals &= Objects.equals(this.attributeName(), other.attributeName());
        equals &= Objects.equals(this.valueType(), other.valueType());
        return equals &= Objects.equals(this.valueComponentType(), other.valueComponentType());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("configKey", () -> this.configKey(), __META_PROPS.get("configKey"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("attributeName", () -> this.attributeName(), __META_PROPS.get("attributeName"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("valueType", () -> this.valueType(), __META_PROPS.get("valueType"), userDefinedCtx, Class.class, new Class[0]);
        visitor.visit("valueComponentType", () -> this.valueComponentType(), __META_PROPS.get("valueComponentType"), userDefinedCtx, Optional.class, new Class[]{Class.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ConfigResolverRequest>
    implements ConfigResolverRequest,
    io.helidon.common.Builder<B, T> {
        private String configKey;
        private String attributeName;
        private Class valueType;
        private Optional valueComponentType = Optional.empty();

        protected Builder() {
        }

        @Override
        public String configKey() {
            return this.configKey;
        }

        @Override
        public String attributeName() {
            return this.attributeName;
        }

        public Class valueType() {
            return this.valueType;
        }

        @Override
        public Optional<Class<?>> valueComponentType() {
            return this.valueComponentType;
        }

        public B configKey(String val) {
            this.configKey = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B attributeName(String val) {
            this.attributeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B valueType(Class val) {
            this.valueType = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B valueComponentType(Optional<Class<?>> val) {
            this.valueComponentType = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B valueComponentType(Class<?> val) {
            Objects.requireNonNull(val);
            return this.valueComponentType(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.configKey(val.configKey());
            this.attributeName(val.attributeName());
            this.valueType(val.valueType());
            this.valueComponentType(val.valueComponentType());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("configKey", () -> this.configKey, __META_PROPS.get("configKey"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("attributeName", () -> this.attributeName, __META_PROPS.get("attributeName"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("valueType", () -> this.valueType, __META_PROPS.get("valueType"), userDefinedCtx, Class.class, new Class[0]);
            visitor.visit("valueComponentType", () -> this.valueComponentType, __META_PROPS.get("valueComponentType"), userDefinedCtx, Optional.class, new Class[]{Class.class});
        }
    }
}

