/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.builder.AttributeVisitor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface ConfigBeanBuilderValidator<CBB> {
    public ValidationRound createValidationRound(CBB var1, Class<CBB> var2);

    public static class ValidationIssue {
        private final Severity severity;
        private final String attributeName;
        private final String message;

        public ValidationIssue(Severity severity, String attributeName, String message) {
            this.severity = Objects.requireNonNull(severity);
            this.attributeName = Objects.requireNonNull(attributeName);
            this.message = Objects.requireNonNull(message);
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }
    }

    public static interface ValidationRound
    extends AttributeVisitor<Object> {
        public List<ValidationIssue> getIssues();

        default public boolean hasIssues() {
            return !this.getIssues().isEmpty();
        }

        default public boolean hasErrors() {
            return this.getIssues().stream().anyMatch(it -> it.getSeverity() == Severity.ERROR);
        }

        public boolean isCompleted();

        public ValidationRound validate(String var1, Supplier<?> var2, Class<?> var3, Map<String, Object> var4);

        default public void visit(String attributeName, Supplier<Object> valueSupplier, Map<String, Object> meta, Object userDefinedCtx, Class<?> cbType, Class<?> ... ignored) {
            this.validate(attributeName, valueSupplier, cbType, meta);
        }

        public ValidationRound finish(boolean var1);
    }

    public static enum Severity {
        WARNING,
        ERROR;

    }
}

