/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.pico.builder.config.spi.ConfigBeanBuilderValidator;
import io.helidon.pico.builder.config.spi.ConfigBeanBuilderValidatorProvider;
import java.util.Optional;
import java.util.ServiceLoader;

public class ConfigBeanBuilderValidatorHolder {
    private static final LazyValue<Optional<ConfigBeanBuilderValidator<?>>> INSTANCE = LazyValue.create(ConfigBeanBuilderValidatorHolder::load);

    private ConfigBeanBuilderValidatorHolder() {
    }

    public static <CBB> Optional<ConfigBeanBuilderValidator<CBB>> configBeanValidatorFor(Class<CBB> configBeanBuilderType) {
        return (Optional)INSTANCE.get();
    }

    private static Optional<ConfigBeanBuilderValidator<?>> load() {
        Optional provider = HelidonServiceLoader.create(ServiceLoader.load(ConfigBeanBuilderValidatorProvider.class, ConfigBeanBuilderValidatorProvider.class.getClassLoader())).asList().stream().findFirst();
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((ConfigBeanBuilderValidatorProvider)provider.get()).configBeanBuilderValidator());
    }
}

