/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.builder.Builder;
import io.helidon.pico.builder.config.ConfigBean;
import io.helidon.pico.builder.config.spi.MetaConfigBeanInfo;
import java.util.Objects;

@Builder(implPrefix="Meta")
public interface ConfigBeanInfo
extends ConfigBean {
    public static MetaConfigBeanInfo toMetaConfigBeanInfo(ConfigBean val, Class<?> cfgBeanType) {
        Objects.requireNonNull(cfgBeanType);
        MetaConfigBeanInfo.Builder builder = MetaConfigBeanInfo.toBuilder(Objects.requireNonNull(val));
        String key = val.key();
        if (!key.isBlank()) {
            builder.key(ConfigBeanInfo.toConfigKey(cfgBeanType.getSimpleName()));
        }
        return builder.build();
    }

    public static String toConfigKey(String name) {
        char[] chars;
        StringBuilder result = new StringBuilder(name.length() + 5);
        for (char aChar : chars = name.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.length() == 0) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }
}

